package cn.com.tuia.advert.model;

import com.alibaba.fastjson.JSON;
import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.Map;

/**
 * 激励广告请求
 */
public class ObtainEncourageAdvertReq implements Serializable {

    private static final long serialVersionUID = 7371676541293127274L;

    /**
     * 点击按钮的用户id
     */
    private Long consumerId;

    /**
     * 点击按钮的客户端的UA
     */
    private String ua;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 点击按钮的客户端的ip
     */
    private String ip;

    /**
     * 发生点击事件的app的id
     */
    private Long appId;

    /**
     * 福袋被添加的活动ID
     */
    private Long activityId;

    /**
     * 活动标签.
     */
    private String tag;

    /**
     * 客户端时间戳，毫秒
     */
    private Long timestamp;

    /**
     * 用户使用系统
     */
    private String os;

    /**
     * 点击：0，曝光：1，请求：2，发券：3，计费：4
     */
    private String type;

    private String userAgent;

    /**
     * 在cookie中写入的设备id
     */
    private String deviceId;

    /**
     * 当前系统时间
     */
    private String time;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 活动类型 插件活动为 1
     */
    private Integer activityType;

    /**
     * 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20
     */
    private Integer activityUseType;

    /**
     * 兑吧活动类型 ， 从兑吧传过来的活动类型，避免tuia-engine再次查询而形成相互依赖 2016-12-20
     */
    private Integer duibaActivityType;

    /**
     * 兑吧活动id ， 从兑吧传过来的活动id，避免tuia-engine再次查询而形成相互依赖 2016-12-20
     */
    private Long duibaActivityId;

    /**
     * 活动场景类型 1-插件工具、2-活动工具、3-直投页，4展示广告
     */
    private Integer activitySceneType;

    /*** 当前用户是否代理/VPN流量 true:是，false：否 */
    private Boolean isProxy = Boolean.FALSE;

    /**
     * 日志扩展map，仅用于记录日志
     */
    private Map<String, String> logExtMap;

    /**
     * 素材类型,1-展示广告大图、2-展示广告小图
     */
    private Integer materialType;

    /**
     * 本次请求期望返回广告个数
     */
    private Integer advertCount;

    /**
     * 投放类型：1-福袋 2-直投 3-浮标
     */
    private int deliveryType;

    public ObtainEncourageAdvertReq() {
        super();
        DateTime nowTime = new DateTime();
        this.time = nowTime.toString("yyyy-MM-dd HH:mm:ss");
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Long getSlotId() {
        return slotId;
    }

    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityUseType() {
        return activityUseType;
    }

    public void setActivityUseType(Integer activityUseType) {
        this.activityUseType = activityUseType;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public Integer getActivitySceneType() {
        return activitySceneType;
    }

    public void setActivitySceneType(Integer activitySceneType) {
        this.activitySceneType = activitySceneType;
    }

    public Boolean getProxy() {
        return isProxy;
    }

    public void setProxy(Boolean proxy) {
        isProxy = proxy;
    }

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public Integer getAdvertCount() {
        return advertCount;
    }

    public void setAdvertCount(Integer advertCount) {
        this.advertCount = advertCount;
    }

    public int getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(int deliveryType) {
        this.deliveryType = deliveryType;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
