package cn.com.tuia.advert.enums;

/**
 * @author zhangmeng
 * @date 2019/2/27
 * @function 全链路数据跟踪
 */
public enum DataTraceEnum {

    /**
     * 地域
     */
    REGION("region","地域"),

    /**
     * 平台
     */
    PLATFORM("platform","平台"),

    /**
     * 已领取过的广告
     */
    RECEIVED("received","已领取过的广告"),

    /**
     * 屏蔽标签
     */
    BANND_TAG("banndTag","屏蔽标签"),

    /**
     * 限流媒体
     */
    LIMIT_APP("limitApp","限流媒体"),

    /**
     * 活动类型
     */
    ACTIVITY_TYPE("activityType","活动类型"),

    /**
     * 参与次数
     */
    JOIN_NUM("joinNum","参与次数"),

    /**
     * 配置日预算
     */
    BUDGET_PER_DAY("budgetPerDay","配置日预算"),

    /**
     * 投放时段过滤
     */
    PERIOD("period","投放时段过滤"),

    /**
     * 屏蔽流量类型
     */
    BANNED_APP_FLOW_TYPE("bannedAppFlowType","屏蔽流量类型"),

    /**
     * 媒体广告互选
     */
    APP_SELECT_ADVERT("appSelectAdvert","媒体广告互选"),

    /**
     * 人群兴趣点
     */
    USER_INTEREST("userInterest","人群兴趣点"),

    /**
     * 屏蔽落地页链接
     */
    BANNED_URLS("bannedUrls","屏蔽落地页链接"),

    /**
     * 年龄
     */
    AGE("age","年龄"),

    /**
     *性别
     */
    SEX("sex","性别"),

    /**
     * 工作状态
     */
    WORK_STATE("workState","工作状态"),

    /**
     * 运营商
     */
    OPERATOR("operator","运营商"),

    /**
     * 手机价格区间
     */
    PHONE_LEVEAL("phoneLeveal","手机价格区间"),

    /**
     * 网络类型
     */
    NETWORK_TYPE("networkType","网络类型"),

    /**
     * 手机品牌名称
     */
    BRAND_NAME("brandName","手机品牌名称"),

    /**
     * 轮流投放
     */
    TAKE_TURNS("takeTurns","轮流投放"),

    /**
     * 定向媒体
     */
    TARGET_APP("targetApp","定向媒体"),

    /**
     * tuia活动
     */
    TUIA_ACTIVITY("tuiaActivity","tuia活动");

    private String name;

    private String desc;

    DataTraceEnum(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public static DataTraceEnum getDataByName(String name){

        for(DataTraceEnum item:DataTraceEnum.values()){
            if(item.name.equals(name)){
                return item;
            }
        }

        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
