/**
 * 文件名： ObtainAdvertRsp.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月27日 下午10:33:41
 */
package cn.com.tuia.advert.model;

import java.io.Serializable;
import java.util.Map;

/**
 * 展示广告接口返回结果 <br/>
 *
 * @author: sunjiangrong
 * @创建时间: 2016年4月27日 下午10:33:41
 * @version:
 */
public class ObtainShowAdvertRsp implements Serializable {

    private static final long   serialVersionUID = 7572974780638022488L;

    /** 订单id */
    private String              orderId;

    /** The result. */
    private boolean             result;

    /** 广告ID. */
    private long                advertId;

    /** 广告所属广告主名称. */
    private String              advertiserName;

    /** 详情图的url地址. */
    private String              bannerPngUrl;

    /** 券的标题. */
    private String              title;

    /** 券的副标题. */
    private String              viceTitle;

    /** 推广网址. */
    private String              promoteUrl;

    /** 广告订单Id */
    private Long                advertOrderId;

    /** 素材ID 确认展示的素材 */
    private Long                materialId;

    /**
     * 定向配置包ID
     */
    private Long                adSpecId;

    /** 特权广告库字段 */
    private boolean             privilege;

    /** 0 = 普通流量 2 = 优质流量 */
    private Long                flowTag;

    /** 是否是免费券 0:免费券，1:付费券 **/
    private Integer             isFreeAdvert;

    /** 日志扩展map */
    private Map<String, Object> logExtMap;

    /**
     * logExtMap.
     *
     * @return the logExtMap
     * @since JDK 1.8
     */
    public Map<String, Object> getLogExtMap() {
        return logExtMap;
    }

    /**
     * logExtMap.
     *
     * @param logExtMap the logExtMap to set
     * @since JDK 1.8
     */
    public void setLogExtMap(Map<String, Object> logExtMap) {
        this.logExtMap = logExtMap;
    }

    /**
     * orderId.
     *
     * @return the orderId
     * @since JDK 1.8
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     * @since JDK 1.8
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Integer getIsFreeAdvert() {
        return isFreeAdvert;
    }

    public void setIsFreeAdvert(Integer isFreeAdvert) {
        this.isFreeAdvert = isFreeAdvert;
    }

    public Long getFlowTag() {
        return flowTag;
    }

    public void setFlowTag(Long flowTag) {
        this.flowTag = flowTag;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * advertOrderId.
     *
     * @return the advertOrderId
     * @since JDK 1.6
     */
    public Long getAdvertOrderId() {
        return advertOrderId;
    }

    /**
     * advertOrderId.
     *
     * @param advertOrderId the advertOrderId to set
     * @since JDK 1.6
     */
    public void setAdvertOrderId(Long advertOrderId) {
        this.advertOrderId = advertOrderId;
    }

    /**
     * Checks if is result.
     *
     * @return the result
     */
    public boolean isResult() {
        return result;
    }

    /**
     * Sets the result.
     *
     * @param result the result to set
     */
    public void setResult(boolean result) {
        this.result = result;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the advertiser name.
     *
     * @return the advertiser name
     */
    public String getAdvertiserName() {
        return advertiserName;
    }

    /**
     * Sets the advertiser name.
     *
     * @param advertiserName the advertiser name
     */
    public void setAdvertiserName(String advertiserName) {
        this.advertiserName = advertiserName;
    }

    /**
     * Gets the banner png url.
     *
     * @return the banner png url
     */
    public String getBannerPngUrl() {
        return bannerPngUrl;
    }

    /**
     * Sets the banner png url.
     *
     * @param bannerPngUrl the banner png url
     */
    public void setBannerPngUrl(String bannerPngUrl) {
        this.bannerPngUrl = bannerPngUrl;
    }

    /**
     * Gets the title.
     *
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title.
     *
     * @param title the title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Gets the vice title.
     *
     * @return the vice title
     */
    public String getViceTitle() {
        return viceTitle;
    }

    /**
     * Sets the vice title.
     *
     * @param viceTitle the vice title
     */
    public void setViceTitle(String viceTitle) {
        this.viceTitle = viceTitle;
    }

    /**
     * Gets the promote url.
     *
     * @return the promote url
     */
    public String getPromoteUrl() {
        return promoteUrl;
    }

    /**
     * Sets the promote url.
     *
     * @param promoteUrl the promote url
     */
    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public Long getAdSpecId() {
        return adSpecId;
    }

    public void setAdSpecId(Long adSpecId) {
        this.adSpecId = adSpecId;
    }

    public boolean isPrivilege() {
        return privilege;
    }

    public void setPrivilege(boolean privilege) {
        this.privilege = privilege;
    }

}
