/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public enum AdvertSubtypeEnum {
    CVR(0, "\u843d\u5730\u9875\u8f6c\u5316"),
    INSTALL(1, "\u5b89\u88c5"),
    START(2, "\u6fc0\u6d3b(\u542f\u52a8)"),
    REGISTER(3, "\u6ce8\u518c"),
    ACTIVITY(4, "\u5f85\u5b9a\uff08\u76ee\u524d\u6ca1\u7528\uff09"),
    LOGIN(5, "\u767b\u5f55"),
    PAY(6, "\u4ed8\u8d39"),
    ENTRY(7, "\u8fdb\u4ef6"),
    FINISH(8, "\u5b8c\u4ef6"),
    SIGN_FOR(9, "\u7b7e\u6536"),
    DENY(10, "\u7559\u5b58");

    public static HashMap<Integer, AdvertSubtypeEnum> ADVERT_SUBTYPE_MAPPING;
    private Integer subtype;
    private String desc;
    private static Map<Integer, AdvertSubtypeEnum> enumMap;

    public Integer getSubtype() {
        return this.subtype;
    }

    public void setSubtype(Integer subtype) {
        this.subtype = subtype;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private AdvertSubtypeEnum(Integer subtype, String desc) {
        this.subtype = subtype;
        this.desc = desc;
    }

    public static AdvertSubtypeEnum getSubtypeEnumBySubtype(Integer subtype) {
        return ADVERT_SUBTYPE_MAPPING.get(subtype);
    }

    public static AdvertSubtypeEnum getBySubtype(Integer subtype) {
        return enumMap.get(subtype);
    }

    static {
        ADVERT_SUBTYPE_MAPPING = Maps.newHashMap();
        ADVERT_SUBTYPE_MAPPING.put(0, CVR);
        ADVERT_SUBTYPE_MAPPING.put(1, INSTALL);
        ADVERT_SUBTYPE_MAPPING.put(2, START);
        ADVERT_SUBTYPE_MAPPING.put(3, REGISTER);
        ADVERT_SUBTYPE_MAPPING.put(4, ACTIVITY);
        ADVERT_SUBTYPE_MAPPING.put(5, LOGIN);
        ADVERT_SUBTYPE_MAPPING.put(6, PAY);
        ADVERT_SUBTYPE_MAPPING.put(7, ENTRY);
        ADVERT_SUBTYPE_MAPPING.put(8, FINISH);
        ADVERT_SUBTYPE_MAPPING.put(9, SIGN_FOR);
        ADVERT_SUBTYPE_MAPPING.put(10, DENY);
        enumMap = Maps.newHashMap();
        for (AdvertSubtypeEnum it : AdvertSubtypeEnum.values()) {
            enumMap.put(it.getSubtype(), it);
        }
    }
}

