/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums.userinfo;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;

public enum WorkStateEnum {
    STUDENT(0, "student"),
    WROK(1, "work"),
    WORKOTHER(1, "workother");

    private int code;
    private String desc;

    private WorkStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Optional<List<String>> getWorkStateByCode(int code) {
        List wordList = Stream.of(WorkStateEnum.values()).filter(workState -> workState.getCode() == code).map(WorkStateEnum::getDesc).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(wordList)) {
            return Optional.of(wordList);
        }
        return Optional.empty();
    }

    public static boolean isCorrect(Integer code) {
        if (code != null) {
            return WorkStateEnum.getWorkStateByCode(code).isPresent();
        }
        return false;
    }
}

