/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums;

import cn.com.tuia.advert.enums.AdvertSubtypeEnum;
import cn.com.tuia.advert.enums.ChargeTypeEnum;
import cn.com.tuia.advert.enums.PackageTypeEnum;
import cn.com.tuia.advert.enums.PutTargetTypeEnum;
import cn.com.tuia.advert.enums.SwitchTypeEnum;

public enum DisAppFeeTypeEnum {
    DEFULT_TYPE(0, "\u65e0\u66ff\u6362\u51fa\u4ef7"),
    SIGN_FOR_APP_TYPE(1, "\u4f18\u5316\u76ee\u6807\u4e3a\u7b7e\u6536\u7684\u5206\u5a92\u4f53\u51fa\u4ef7\uff1a\u7cfb\u7edf\u6258\u7ba1ocpc+\u4f18\u5316\u76ee\u6807\uff08\u7b7e\u6536\uff09+\u4f18\u5316\u76ee\u6807\uff08\u4eba\u5de5\u5b9a\u5411\uff09"),
    IMPORTANT_APP_TYPE(2, "\u91cd\u70b9\u5a92\u4f53\u8f6c\u5316\u51fa\u4ef7\uff1a\u7cfb\u7edf\u6258\u7ba1ocpc+\u4f18\u5316\u76ee\u6807\uff08\u843d\u5730\u9875\uff0c\u6ce8\u518c\uff0c\u6fc0\u6d3b\uff09+\u6295\u653e\u76ee\u6807\uff08\u6d88\u8017\u4f18\u5148\uff0c\u6210\u672c\u4f18\u5148\uff0c\u5747\u8861\u6295\u653e\uff09"),
    ORDINARY_APP_CPC_TYPE(3, "\u666e\u901a\u7684\u5206\u5a92\u4f53\u8f6c\u5316\u51fa\u4ef7\uff1a\u4eba\u5de5\u6295\u653ecpc+\u672a\u5f00\u542f\u6f5c\u529b\u5e7f\u544a\u6276\u6301"),
    ORDINARY_APP_CPA_TYPE(4, "\u666e\u901a\u7684\u5206\u5a92\u4f53\u8f6c\u5316\u51fa\u4ef7\uff1a\u7cfb\u7edf\u6258\u7ba1ocpc+\u4f18\u5316\u76ee\u6807\uff08\u843d\u5730\u9875\uff0c\u6ce8\u518c\uff0c\u6fc0\u6d3b\uff09+\u6295\u653e\u76ee\u6807\uff08\u4eba\u5de5\u5b9a\u5411\uff09"),
    POTENTIAL_APP_TYPE(5, "\u6f5c\u529b\u5e7f\u544a\u6276\u6301\u5206\u5a92\u4f53\u51fa\u4ef7\uff1a\u4eba\u5de5\u6295\u653ecpc+\u5f00\u542f\u6f5c\u529b\u5e7f\u544a\u6276\u6301"),
    POTENTIAL_APP_OVER_TYPE(6, "\u6f5c\u529b\u5e7f\u544a\u6276\u6301\u7ed3\u675f\u540e\u5206\u5a92\u4f53\u51fa\u4ef7\uff1a\u4eba\u5de5\u6295\u653ecpc+\u6f5c\u529b\u5e7f\u544a\u6276\u6301\u7ed3\u675f");

    private Integer code;
    private String desc;

    private DisAppFeeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DisAppFeeTypeEnum getByCode(Integer code) {
        for (DisAppFeeTypeEnum enumVal : DisAppFeeTypeEnum.values()) {
            if (code != enumVal.getCode()) continue;
            return enumVal;
        }
        return null;
    }

    public static DisAppFeeTypeEnum getByType(Integer subtype, Integer packageType, Integer chargeType, Integer putTargetType, Integer potentialType) {
        if (packageType == null || chargeType == null) {
            return DEFULT_TYPE;
        }
        if (PackageTypeEnum.INTERACTIVE_TYPE.getCode().equals(packageType)) {
            if (potentialType == null || SwitchTypeEnum.CLOSE_TYPE.getCode().intValue() == potentialType.intValue()) {
                return ORDINARY_APP_CPC_TYPE;
            }
            if (potentialType == 1) {
                return POTENTIAL_APP_TYPE;
            }
            if (potentialType > 1) {
                return POTENTIAL_APP_OVER_TYPE;
            }
            return ORDINARY_APP_CPC_TYPE;
        }
        if (ChargeTypeEnum.TYPE_CPC.getCode() == chargeType.intValue()) {
            return DEFULT_TYPE;
        }
        AdvertSubtypeEnum subtypeEnum = AdvertSubtypeEnum.getBySubtype(subtype);
        switch (subtypeEnum) {
            case SIGN_FOR: {
                if (PutTargetTypeEnum.manual_target.getPutTargetType().equals(putTargetType)) {
                    return SIGN_FOR_APP_TYPE;
                }
                return DEFULT_TYPE;
            }
            case CVR: 
            case START: 
            case REGISTER: {
                if (putTargetType == null) {
                    return DEFULT_TYPE;
                }
                if (PutTargetTypeEnum.manual_target.getPutTargetType().equals(putTargetType)) {
                    return ORDINARY_APP_CPA_TYPE;
                }
                return IMPORTANT_APP_TYPE;
            }
        }
        return DEFULT_TYPE;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

