/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.stream;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamUtils {
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public static <T, R> List<R> toList(Collection<T> collection, Function<? super T, R> keyExtractor) {
        return StreamUtils.toList(collection, keyExtractor, null, null);
    }

    public static <T, R> Set<R> toSet(Collection<T> collection, Function<? super T, R> keyExtractor) {
        return StreamUtils.toSet(collection, keyExtractor, null);
    }

    public static <T, R> List<R> toList(Collection<T> collection, Function<? super T, R> keyExtractor, Predicate<? super T> predicate, Boolean isDistinct) {
        Stream<Object> stream = collection.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        if (isDistinct != null && isDistinct.booleanValue()) {
            return stream.map(keyExtractor).distinct().collect(Collectors.toList());
        }
        return stream.map(keyExtractor).collect(Collectors.toList());
    }

    public static <T, R> List<R> toDistinctList(Collection<T> collection, Function<? super T, R> keyExtractor) {
        return StreamUtils.toList(collection, keyExtractor, null, true);
    }

    public static <T, R> Set<R> toSet(Collection<T> collection, Function<? super T, R> keyExtractor, Predicate<? super T> predicate) {
        Stream<Object> stream = collection.stream();
        if (predicate != null) {
            stream = stream.filter(predicate);
        }
        return stream.map(keyExtractor).collect(Collectors.toSet());
    }

    public static <T, K, U> Map<K, U> toMap(Collection<T> collection, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        Objects.requireNonNull(collection);
        Stream<Object> stream = collection.stream();
        BiConsumer<Map, Object> accumulator = (map, element) -> map.put(keyMapper.apply(element), valueMapper.apply(element));
        BiConsumer<Map, Map> combiner = (a, b) -> a.putAll(b);
        return stream.collect(HashMap::new, accumulator, combiner);
    }
}

