/*
 * Decompiled with CFR 0.152.
 */
package cn.com.tuia.advert.enums.userinfo;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public enum SexEnum {
    FEMALE(0, "female"),
    MALE(1, "male"),
    NO_LIMIT(2, null);

    private int code;
    private String desc;

    private SexEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Optional<String> getSexByCode(int code) {
        for (SexEnum value : SexEnum.values()) {
            if (value.getCode() != code || code == NO_LIMIT.getCode()) continue;
            return Optional.of(value.getDesc());
        }
        return Optional.empty();
    }

    public static boolean isCorrect(Integer code) {
        return Stream.of(SexEnum.values()).map(SexEnum::getCode).anyMatch(temp -> Objects.equals(code, temp));
    }
}

