package cn.com.tuia.advert.fallback;

import cn.com.tuia.advert.adxService.AdxEngineService;
import cn.com.tuia.advert.model.*;
import com.google.common.collect.Lists;

/**
 * adx出券请求熔断处理类
 *
 * @author peanut.huang
 * @date 2019/7/4
 * @since JDK 1.8
 */
public class AdxEngineServiceFallbackImpl implements AdxEngineService {

    /**
     * 调用方判断当rsp返回结果中的列表长度为1且advertId为-1时即发生了熔断
     *
     * @param req
     * @return
     */
    @Override
    public ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req) {

        // 属性赋值 AdxPreloadAdvertDto
        AdxLoadAdvertDto dto = new AdxLoadAdvertDto();
        dto.setAdvertId(-1L);

        ObtainAdvertRsp rsp = new ObtainAdvertRsp();
        rsp.setAdxAdvertList(Lists.newArrayList(dto));

        return rsp;
    }

    @Override
    public ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req) {
        return null;
    }

    @Override
    public QueryAdvertRsp queryAdvert(QueryAdvertReq req) {
        return null;
    }
}
