package cn.com.tuia.advert.enums;

import lombok.Getter;

import java.util.Objects;

/**
 * @author zhanganbo
 * 2019-07-02 下午 17:53
 */
@Getter
public enum CurrentMainStatusEnum {

    ORIGINAL_MAIN_TYPE_STATUS(1,"无主体变更信息"),
    ORIGINAL_MAIN_TYPE_CHANGING_STATUS(2,"处于变更主体的中间态(即切换了新主体，生效的是老主体余额)"),
    CURRENT_MAIN_TYPE_CHANGE_SUCCESS_STATUS(3,"成功变更了主体信息");


    /** 状态 */
    private Integer status;
    /** 描述 */
    private String desc;
    CurrentMainStatusEnum(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    public static CurrentMainStatusEnum getByStatus(Integer status){
        if(Objects.isNull(status)){
            return null;
        }
        for(CurrentMainStatusEnum enumVal : CurrentMainStatusEnum.values()){
            if(Objects.equals(status, enumVal.status)){
                return enumVal;
            }
        }
        return null;
    }
}
