package cn.com.tuia.advert.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AbnormalMonitoringHandleTypeEnum <br/>
 * Function: 广告异常监控-处理类型枚举. <br/>
 * 处理：1-钉钉提醒，2-暂停计划并发送钉钉提醒，3-关闭配置并发送钉钉提醒，4-仅自动加入限流媒体，5-自动加入限流媒体并发送钉钉提醒
 * date: 2019年3月26日 下午6:54:16 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AbnormalMonitoringHandleTypeEnum {
    /** 钉钉提醒 */
    DING_TALK_MESSAGE(1, "钉钉提醒"),

    /** 暂停计划并发送钉钉提醒 */
    PAUSE_AD_DING_TALK(2, "暂停计划并发送钉钉提醒"),

    /** 关闭配置并发送钉钉提醒 */
    CLOSE_ORIENT_DING_TALK(3, "关闭配置并发送钉钉提醒"),

    /** 仅自动加入配置限流媒体 */
    ORIENT_LIMIT_APP(4, "仅自动加入限流媒体"),

    /** 自动加入限流媒体并发送钉钉提醒 */
    ORIENT_LIMIT_APP_DING_TALK(5, "自动加入限流媒体并发送钉钉提醒");

    private String desc;

    private Integer code;

    AbnormalMonitoringHandleTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AbnormalMonitoringHandleTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AbnormalMonitoringHandleTypeEnum it : AbnormalMonitoringHandleTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AbnormalMonitoringHandleTypeEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
