package cn.com.tuia.advert.service;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.model.AdvOrientationDto;

/**
 * 互动广告内存服务接口
 *
 * @author peanut.huang
 * @date 2019/1/28
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface InteractiveMemoryService {

    /**
     * 获取互动广告集群机器列表
     *
     * @return
     */
    List<String> findServerList();

    /**
     * 根据广告计划id与配置id获取内存中的配置数据
     *
     * @param advertId        计划id
     * @param orientationId   配置id
     * @return
     */
    AdvOrientationDto findAdvOrientation(Long advertId, Long orientationId);

    /**
     * 刷新广告缓存
     *
     * @param advertId        计划id
     * @param orientationId   配置id
     * @return
     */
    Boolean refreshAdvOrientation(Long advertId, Long orientationId);
}
