package cn.com.tuia.advert.encourageService;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.EncourageMaterialDto;
import cn.com.tuia.advert.model.ObtainEncourageAdvertReq;
import cn.com.tuia.advert.model.ObtainEncourageAdvertRsp;
import cn.com.tuia.advert.model.QueryEnAdvertOrderRsp;
import cn.com.tuia.advert.model.QueryEncourageAdvertRsp;

import java.util.List;

@AdvancedFeignClient
public interface EncourageEngineService {

    /**
     * 请求激励广告接口(出券).
     */
    ObtainEncourageAdvertRsp obtainEncourageAdvert(ObtainEncourageAdvertReq req) throws ReadableMessageException;

    /**
     * 查询并校验广告详情接口
     *
     * @param advertId 广告ID
     * @return 广告是否有效和广告详情
     */
    QueryEncourageAdvertRsp queryAdvert(Long advertId);

    /**
     * 查询广告订单详情
     *
     * @param orderId   订单ID
     * @param consumeId 用户ID
     * @return
     */
    QueryEnAdvertOrderRsp queryEncourageAdvertOrder(String orderId, Long consumeId);


    /**
     * 根据广告id查询 激励广告素材
     * @param advertId
     * @return
     */
    public List<EncourageMaterialDto> getEncourageMaterialByAdvertId(Long advertId);
}
