package cn.com.tuia.advert.Tool;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class PkgPutTargetTypeByWhite {

    private static final Logger logger = LoggerFactory.getLogger(PkgPutTargetTypeByWhite.class);

    //优投模式
    private static final Integer OPTIMAL_MODE = 3;

    /**
     * 如果在白名单内，替换投放目标
     * @param smartCompatibleList 白名单：：配置ID_投放目标
     * @param targetAppLimit 投放模式(定向模式，2-自动模式，3-优投模式)
     * @param initialOrientationId 原始配置ID
     * @param putTargetType 投放目标
     * @return
     */
    public static Integer coverPkgPutTargetTypeByWhite(List<String> smartCompatibleList, Integer targetAppLimit, Long initialOrientationId, Integer putTargetType) {

        //如果白名单为空，则直接返回本来的
        if (CollectionUtils.isEmpty(smartCompatibleList)) {
            return putTargetType;
        }

        try {
            //如果配置是优投模式（人工定向）
            if (OPTIMAL_MODE.equals(targetAppLimit)) {

                String orinalidStr = initialOrientationId + "_";

                //便利白名单
                for (String orinalidPutTargetType : smartCompatibleList) {

                    //如果在白名单内,格式:465465_1
                    if (orinalidPutTargetType.contains(orinalidStr)) {

                        //获取白名单中的投放目标，进行替换。
                        putTargetType = Integer.parseInt(orinalidPutTargetType.substring(orinalidPutTargetType.length() - 1));

                        return putTargetType;
                    }
                }
            }

        } catch (Exception e) {
            logger.error("PkgPutTargetTypeByWhite.coverPkgPutTargetTypeByWhite is error, initialOrientationId:{}", initialOrientationId, e);
        }

        return putTargetType;

    }
}
