/**
 * Project Name:tuia-clent<br>
 * File Name:ObtainAdvertExReq.java<br>
 * Package Name:cn.com.tuia.advert.model<br>
 * Date:2016年6月16日下午5:14:51<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.tuia.advert.model;

import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.tuia.advert.constants.CommonConstant;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName: ObtainAdvertExReq <br/>
 * Function: 兑吧请求广告接口的请求参数. <br/>
 * Reason: <br/>
 * date: 2016年6月16日 下午5:14:51 <br/>
 * 
 * @author leiliang
 * @version
 * @since JDK 1.7
 */
public class ObtainAdvertReq implements Serializable {


    private static final long   serialVersionUID = 1L;

    private static final Logger logger = LoggerFactory.getLogger(ObtainAdvertReq.class);

    /** 点击按钮的用户id */
    private Long                consumerId;

    /** 点击按钮的客户端的UA */
    private String              ua;

    /** 承载点击按钮的订单的id，用来判断计费的次数 */
    private String              orderId;

    /** 点击按钮的客户端的ip */
    private String              ip;

    /** 点击按钮的客户端的城市编码 */
    private String              cityId;

    /** geo对应的ip地域信息 */
    private IpAreaDto           ipAreaDto;

    /** 发生点击事件的app的id */
    private Long                appId;

    /** 产品ID */
    private Long                productId;

    /** 福袋被添加的活动ID */
    private Long                activityId;

    /**
     * 激励广告使用的虚拟活动id
     */
    private Long virtualActivityId;

    /** 活动标签. */
    private String              tag;

    /** 客户端时间戳，毫秒 */
    private Long                timestamp;

    /** 登陆状态（未登录：0，登陆：1） */
    private String              loginType;

    /** 按钮埋点号码 */
    private String              buttonType;

    /** 细节类型 */
    private String              infoType;

    /** 细节 */
    private String              info;

    /** 用户使用系统 */
    private String              os;

    /** 点击：0，曝光：1，请求：2，发券：3，计费：4 */
    private String              type;

    private String              userAgent;

    /** 在cookie中写入的设备id */
    private String              deviceId;

    /** 使用指纹生成技术产生的指纹 */
    private String              fingerPrint;

    /** x,y坐标 */
    private String              coordinate;

    /** 浏览器名 */
    private String              browserName;

    /** 浏览器版本 */
    private String              browserVersion;

    /** 浏览器别名 */
    private String              browserAlias;

    /** url */
    private String              url;

    /** url不完全地址 */
    private String              urlPattern;

    /** 上一个url */
    private String              preUrl;

    /** 上一个url不完全地址 */
    private String              preurlPattern;

    /** 当前系统时间 */
    private String              time;

    /** 广告位ID */
    private Long                slotId;

    /** 广告ID */
    private Long                advertId;

    /** 执行结果code. */
    private String              result;

    /** 执行结果说明. */
    private String              message;

    //是否需要替换低arpu值的券，1-要、0-不要
    private Integer replaceLowArpu;

    /** 活动类型 插件活动为 1 */
    private Integer             activityType;

    /** 活动使用类型，0：普通活动，1：商业化活动,2:推啊活动。 用于区分定制化广告和白名单广告 2016-12-20 */
    private Integer             activityUseType;

    /** 兑吧活动类型 ， 从兑吧传过来的活动类型，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Integer             duibaActivityType;

    /** 兑吧活动id ， 从兑吧传过来的活动id，避免tuia-engine再次查询而形成相互依赖 2016-12-20 */
    private Long                duibaActivityId;

    //活动场景类型 1-插件工具、2-活动工具、3-直投页
    private Integer             activitySceneType;

    /***当前用户是否代理/VPN流量  true:是，false：否*/
    private Boolean isProxy = Boolean.FALSE;

    /**  日志扩展map，仅用于记录日志 */
    private Map<String, String> logExtMap;

    /** arup值 */
    private Long              arpuVal;
    
    /** 兑吧广告位id **/
    private Long              duibaSlotId;

    /** 发券时app和广告的标签*/
    private List<String> appTags;

    /**
     * 投放类型：1-福袋 2-直投 3-浮标
     */
    private int deliveryType;

    /** 活动发券次数限制类型：0-普通活动限制，1-特殊活动限制， 2-无限制活动 */
    private Integer actReceiveType;
    
    /** 是否是预加载素材图片：false-正常出券，true-预加载 */
    private boolean preloadingMaterial;

    /** 操作系统版本*/
    private String osVersion;

    /**
     * 进入活动开始时间
     */
    private Long beginTime;

    /**
     * des秘钥
     */
    private String advertNewVal;

    /**
     * des和md5 加密
     */
    private String advertMdVal;

    /**
     * 发券接口防刷 状态：0-正常、1-非法
     */
    private Integer antiBrushType;

    /**
     * adx券请求类型，1：预发券，2：真实发券
     */
    private Integer adxLoadType;

    /**
     * adx预发券的编码如AiQiYi，为空可能是直投（非竞价预发券）
     */
    private String adxCodePre;

    /**
     * 用户信息类型
     *
     * 1,"年龄特征"
     * 2,"身份特征"
     *
     */
    private Integer personCrowdType;

    /**
     * 用户信息
     *
     * 0,"女或者学生"
     * 1,"男或者不是学生"
     */
    private Integer personCrowdValue;

    /**
     * 广告投放类型：1、互动广告（默认，为空也是互动）2、视频广告
     */
    private String adType;

    /**
     * adx媒体类型，0-无区分，1-美团
     */
    private Integer adxMediaType;

    /**
     * 分流标志
     */
    private Integer isTage;

    /**
     * 直投广告计划白名单列表
     */
    private List<Long> directlyAdvertIdList;


    //adxId
    private Long adxId;

    //样式ID
    private List<Long> adxStyleIdList;

    /**
     * 增值广告请求时的订单id
     */
    private String encourageOrderId;

    /** 活动请求素材类型*/
    private Integer activityMaterialType;

    /** 预发券状态, 1:预发券，2:非预发券 */
    private Long preLaunch;

    /** 流量付费类型: 0-免费 1-付费 */
    private Integer appPaid;

    /** DSP 平台标识 */
    private Long dspId;

    /**
     * 日志拓展字段，放进该字段的所有数据都将在全链路打印::key和value都不能有","整体这个字符串
     */
    private Map<String, String> logExtExpMap;

    /**
     * 是否为活动预发券
     */
    private Boolean isActPre = false;

    /**
     * 活动预发券, 本次请求期望返回广告个数
     */
    private Integer advertCount;

    /**
     * 活动预发券, 新行业标签，（ 空 or null）为全部
     */
    private String actPreNewTradeTagName;

    /** 订单id集合 */
    private List<String>        orderIds;

    public List<String> getOrderIds() {
        return orderIds;
    }

    public void setOrderIds(List<String> orderIds) {
        this.orderIds = orderIds;
    }

    public Map<String, String> getLogExtExpMap() {

        String jsonString = JSONObject.toJSONString(logExtExpMap);
        if(jsonString.length() > CommonConstant.LOG_MAP_SIZE){
            logger.warn("logExtExpMap.size is too long, logEpJson:{}", jsonString);
            return new HashMap<>();
        }

        return logExtExpMap;
    }

    public void setLogExtExpMap(Map<String, String> logExtExpMap) {
        this.logExtExpMap = logExtExpMap;
    }

    public String getCityId() {
        return cityId;
    }

    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    public Integer getAdxMediaType() {
        return adxMediaType;
    }

    public void setAdxMediaType(Integer adxMediaType) {
        this.adxMediaType = adxMediaType;
    }

    public Integer getAdxLoadType() {
        return adxLoadType;
    }

    public void setAdxLoadType(Integer adxLoadType) {
        this.adxLoadType = adxLoadType;
    }

    public String getEncourageOrderId() { return encourageOrderId; }

    public void setEncourageOrderId(String encourageOrderId) { this.encourageOrderId = encourageOrderId; }

    /**
     * preloadingMaterial.
     *
     * @return  the preloadingMaterial
     * @since   JDK 1.8
     */
    public boolean isPreloadingMaterial() {
        return preloadingMaterial;
    }

    
    /**
     * preloadingMaterial.
     *
     * @param   preloadingMaterial    the preloadingMaterial to set
     * @since   JDK 1.8
     */
    public void setPreloadingMaterial(boolean preloadingMaterial) {
        this.preloadingMaterial = preloadingMaterial;
    }

    public Integer getReplaceLowArpu() {
        return replaceLowArpu;
    }

    public void setReplaceLowArpu(Integer replaceLowArpu) {
        this.replaceLowArpu = replaceLowArpu;
    }

    public IpAreaDto getIpAreaDto() {
        return ipAreaDto;
    }

    public ObtainAdvertReq setIpAreaDto(IpAreaDto ipAreaDto) {
        this.ipAreaDto = ipAreaDto;
        return this;
    }

    /**
     * actReceiveType.
     *
     * @return the actReceiveType
     * @since JDK 1.8
     */
    public Integer getActReceiveType() {
        return actReceiveType;
    }

    /**
     * actReceiveType.
     *
     * @param actReceiveType the actReceiveType to set
     * @since JDK 1.8
     */
    public void setActReceiveType(Integer actReceiveType) {
        this.actReceiveType = actReceiveType;
    }

    public int getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(int deliveryType) {
        this.deliveryType = deliveryType;
    }
	
    public Integer getActivitySceneType() {
        return activitySceneType;
    }

    public void setActivitySceneType(Integer activitySceneType) {
        this.activitySceneType = activitySceneType;
    }

    public Long getArpuVal() {
        return arpuVal;
    }

    public void setArpuVal(Long arpuVal) {
        this.arpuVal = arpuVal;
    }

    public List<String> getAppTags() {
        return appTags;
    }

    public void setAppTags(List<String> appTags) {
        this.appTags = appTags;
    }

    public Map<String, String> getLogExtMap() {
        return logExtMap;
    }

    public void setLogExtMap(Map<String, String> logExtMap) {
        this.logExtMap = logExtMap;
    }

    public Integer getActivityUseType() {
        return activityUseType;
    }

    public void setActivityUseType(Integer activityUseType) {
        this.activityUseType = activityUseType;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public ObtainAdvertReq() {
        super();
        DateTime nowTime = new DateTime();
        String serverTime = nowTime.toString("yyyy-MM-dd HH:mm:ss");
        this.time = serverTime;
    }

    public Long getVirtualActivityId() {
        return virtualActivityId;
    }

    public void setVirtualActivityId(Long virtualActivityId) {
        this.virtualActivityId = virtualActivityId;
    }

    /**
     * activityType.
     * 
     * @return the activityType
     * @since JDK 1.6
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     * 
     * @param activityType the activityType to set
     * @since JDK 1.6
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * result.
     * 
     * @return the result
     * @since JDK 1.6
     */
    public String getResult() {
        return result;
    }

    /**
     * result.
     * 
     * @param result the result to set
     * @since JDK 1.6
     */
    public void setResult(String result) {
        this.result = result;
    }

    /**
     * message.
     * 
     * @return the message
     * @since JDK 1.6
     */
    public String getMessage() {
        return message;
    }

    /**
     * message.
     * 
     * @param message the message to set
     * @since JDK 1.6
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * advertId.
     * 
     * @return the advertId
     * @since JDK 1.6
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     * 
     * @param advertId the advertId to set
     * @since JDK 1.6
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * slotId.
     * 
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     * 
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * timestamp.
     * 
     * @return the timestamp
     * @since JDK 1.6
     */
    public Long getTimestamp() {
        return timestamp;
    }

    /**
     * timestamp.
     * 
     * @param timestamp the timestamp to set
     * @since JDK 1.6
     */
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * time.
     * 
     * @return the time
     * @since JDK 1.6
     */
    public String getTime() {
        return time;
    }

    /**
     * time.
     * 
     * @param time the time to set
     * @since JDK 1.6
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * consumerId.
     * 
     * @return the consumerId
     * @since JDK 1.6
     */
    public Long getConsumerId() {
        return consumerId;
    }

    /**
     * consumerId.
     * 
     * @param consumerId the consumerId to set
     * @since JDK 1.6
     */
    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * ua.
     * 
     * @return the ua
     * @since JDK 1.6
     */
    public String getUa() {
        return ua;
    }

    /**
     * ua.
     * 
     * @param ua the ua to set
     * @since JDK 1.6
     */
    public void setUa(String ua) {
        this.ua = ua;
    }

    /**
     * orderId.
     * 
     * @return the orderId
     * @since JDK 1.6
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     * 
     * @param orderId the orderId to set
     * @since JDK 1.6
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * ip.
     * 
     * @return the ip
     * @since JDK 1.6
     */
    public String getIp() {
        return ip;
    }

    /**
     * ip.
     * 
     * @param ip the ip to set
     * @since JDK 1.6
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * appId.
     * 
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     * 
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * productId.
     * 
     * @return the productId
     * @since JDK 1.6
     */
    public Long getProductId() {
        return productId;
    }

    /**
     * productId.
     * 
     * @param productId the productId to set
     * @since JDK 1.6
     */
    public void setProductId(Long productId) {
        this.productId = productId;
    }

    /**
     * activityId.
     * 
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     * 
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * tag.
     * 
     * @return the tag
     * @since JDK 1.6
     */
    public String getTag() {
        return tag;
    }

    /**
     * tag.
     * 
     * @param tag the tag to set
     * @since JDK 1.6
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /**
     * loginType.
     * 
     * @return the loginType
     * @since JDK 1.6
     */
    public String getLoginType() {
        return loginType;
    }

    /**
     * loginType.
     * 
     * @param loginType the loginType to set
     * @since JDK 1.6
     */
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    /**
     * buttonType.
     * 
     * @return the buttonType
     * @since JDK 1.6
     */
    public String getButtonType() {
        return buttonType;
    }

    /**
     * buttonType.
     * 
     * @param buttonType the buttonType to set
     * @since JDK 1.6
     */
    public void setButtonType(String buttonType) {
        this.buttonType = buttonType;
    }

    /**
     * infoType.
     * 
     * @return the infoType
     * @since JDK 1.6
     */
    public String getInfoType() {
        return infoType;
    }

    /**
     * infoType.
     * 
     * @param infoType the infoType to set
     * @since JDK 1.6
     */
    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    /**
     * info.
     * 
     * @return the info
     * @since JDK 1.6
     */
    public String getInfo() {
        return info;
    }

    /**
     * info.
     * 
     * @param info the info to set
     * @since JDK 1.6
     */
    public void setInfo(String info) {
        this.info = info;
    }

    /**
     * os.
     * 
     * @return the os
     * @since JDK 1.6
     */
    public String getOs() {
        return os;
    }

    /**
     * os.
     * 
     * @param os the os to set
     * @since JDK 1.6
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * type.
     * 
     * @return the type
     * @since JDK 1.6
     */
    public String getType() {
        return type;
    }

    /**
     * type.
     * 
     * @param type the type to set
     * @since JDK 1.6
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * userAgent.
     * 
     * @return the userAgent
     * @since JDK 1.6
     */
    public String getUserAgent() {
        return userAgent;
    }

    /**
     * userAgent.
     * 
     * @param userAgent the userAgent to set
     * @since JDK 1.6
     */
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    /**
     * deviceId.
     * 
     * @return the deviceId
     * @since JDK 1.6
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * deviceId.
     * 
     * @param deviceId the deviceId to set
     * @since JDK 1.6
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * fingerPrint.
     * 
     * @return the fingerPrint
     * @since JDK 1.6
     */
    public String getFingerPrint() {
        return fingerPrint;
    }

    /**
     * fingerPrint.
     * 
     * @param fingerPrint the fingerPrint to set
     * @since JDK 1.6
     */
    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    /**
     * coordinate.
     * 
     * @return the coordinate
     * @since JDK 1.6
     */
    public String getCoordinate() {
        return coordinate;
    }

    /**
     * coordinate.
     * 
     * @param coordinate the coordinate to set
     * @since JDK 1.6
     */
    public void setCoordinate(String coordinate) {
        this.coordinate = coordinate;
    }

    /**
     * browserName.
     * 
     * @return the browserName
     * @since JDK 1.6
     */
    public String getBrowserName() {
        return browserName;
    }

    /**
     * browserName.
     * 
     * @param browserName the browserName to set
     * @since JDK 1.6
     */
    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    /**
     * browserVersion.
     * 
     * @return the browserVersion
     * @since JDK 1.6
     */
    public String getBrowserVersion() {
        return browserVersion;
    }

    /**
     * browserVersion.
     * 
     * @param browserVersion the browserVersion to set
     * @since JDK 1.6
     */
    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    /**
     * browserAlias.
     * 
     * @return the browserAlias
     * @since JDK 1.6
     */
    public String getBrowserAlias() {
        return browserAlias;
    }

    /**
     * browserAlias.
     * 
     * @param browserAlias the browserAlias to set
     * @since JDK 1.6
     */
    public void setBrowserAlias(String browserAlias) {
        this.browserAlias = browserAlias;
    }

    /**
     * url.
     * 
     * @return the url
     * @since JDK 1.6
     */
    public String getUrl() {
        return url;
    }

    /**
     * url.
     * 
     * @param url the url to set
     * @since JDK 1.6
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * urlPattern.
     * 
     * @return the urlPattern
     * @since JDK 1.6
     */
    public String getUrlPattern() {
        return urlPattern;
    }

    /**
     * urlPattern.
     * 
     * @param urlPattern the urlPattern to set
     * @since JDK 1.6
     */
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    /**
     * preUrl.
     * 
     * @return the preUrl
     * @since JDK 1.6
     */
    public String getPreUrl() {
        return preUrl;
    }

    /**
     * preUrl.
     * 
     * @param preUrl the preUrl to set
     * @since JDK 1.6
     */
    public void setPreUrl(String preUrl) {
        this.preUrl = preUrl;
    }

    /**
     * preurlPattern.
     * 
     * @return the preurlPattern
     * @since JDK 1.6
     */
    public String getPreurlPattern() {
        return preurlPattern;
    }

    /**
     * preurlPattern.
     * 
     * @param preurlPattern the preurlPattern to set
     * @since JDK 1.6
     */
    public void setPreurlPattern(String preurlPattern) {
        this.preurlPattern = preurlPattern;
    }

    public Boolean getProxy() {
        return isProxy;
    }

    public void setProxy(Boolean proxy) {
        isProxy = proxy;
    }
    
    
    public Long getDuibaSlotId() {
        return duibaSlotId;
    }

    
    public void setDuibaSlotId(Long duibaSlotId) {
        this.duibaSlotId = duibaSlotId;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Long getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Long beginTime) {
        this.beginTime = beginTime;
    }

    public String getAdvertNewVal() {
        return advertNewVal;
    }

    public void setAdvertNewVal(String advertNewVal) {
        this.advertNewVal = advertNewVal;
    }

    public String getAdvertMdVal() {
        return advertMdVal;
    }

    public void setAdvertMdVal(String advertMdVal) {
        this.advertMdVal = advertMdVal;
    }

    public Integer getAntiBrushType() {
        return antiBrushType;
    }

    public void setAntiBrushType(Integer antiBrushType) {
        this.antiBrushType = antiBrushType;
    }

    public Integer getPersonCrowdType() {
        return personCrowdType;
    }

    public void setPersonCrowdType(Integer personCrowdType) {
        this.personCrowdType = personCrowdType;
    }

    public Integer getPersonCrowdValue() {
        return personCrowdValue;
    }

    public void setPersonCrowdValue(Integer personCrowdValue) {
        this.personCrowdValue = personCrowdValue;
    }

    public String getAdType() {
        return adType;
    }

    public void setAdType(String adType) {
        this.adType = adType;
    }

    public Integer getActivityMaterialType() {
        return activityMaterialType;
    }

    public void setActivityMaterialType(Integer activityMaterialType) {
        this.activityMaterialType = activityMaterialType;
    }

    public Integer getIsTage() {
        return isTage;
    }

    public void setIsTage(Integer isTage) {
        this.isTage = isTage;
    }

    public Long getAdxId() {
        return adxId;
    }

    public void setAdxId(Long adxId) {
        this.adxId = adxId;
    }

    public List<Long> getAdxStyleIdList() {
        return adxStyleIdList;
    }

    public void setAdxStyleIdList(List<Long> adxStyleIdList) {
        this.adxStyleIdList = adxStyleIdList;
    }

    public String getAdxCodePre() {
        return adxCodePre;
    }

    public void setAdxCodePre(String adxCodePre) {
        this.adxCodePre = adxCodePre;
    }

    public List<Long> getDirectlyAdvertIdList() {
        return directlyAdvertIdList;
    }

    public void setDirectlyAdvertIdList(List<Long> directlyAdvertIdList) {
        this.directlyAdvertIdList = directlyAdvertIdList;
    }

    public Long getPreLaunch() {
        return preLaunch;
    }

    public void setPreLaunch(Long preLaunch) {
        this.preLaunch = preLaunch;
    }

    public Integer getAppPaid() {
        return appPaid;
    }

    public void setAppPaid(Integer appPaid) {
        this.appPaid = appPaid;
    }

    public Long getDspId() {
        return dspId;
    }

    public void setDspId(Long dspId) {
        this.dspId = dspId;
    }

    public Boolean getActPre() {
        return isActPre;
    }

    public void setActPre(Boolean actPre) {
        isActPre = actPre;
    }

    public Integer getAdvertCount() {
        return advertCount;
    }

    public void setAdvertCount(Integer advertCount) {
        this.advertCount = advertCount;
    }

    public String getActPreNewTradeTagName() {
        return actPreNewTradeTagName;
    }

    public void setActPreNewTradeTagName(String actPreNewTradeTagName) {
        this.actPreNewTradeTagName = actPreNewTradeTagName;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this);
    }
}
