package cn.com.tuia.advert.model;

import lombok.Data;

import java.io.Serializable;

/**
 * @program: tuia-client
 * @description: rta投放计划
 * @author: Micheal.Wang
 * @blog: <a href="http://www.micheal.top">MichealWang</a>
 * @create: 2020-04-16 13:57
 **/
@Data
public class RTAAdvertPlanDto implements Serializable {

    private static final long serialVersionUID = 7833894667186047031L;

    /**
     * id
     */
    private Long id;
    /**
     * app名称
     */
    private String appName;
    /**
     * appId
     */
    private Long appId;
    /**
     * 绑定tuia在媒体方开的账号id
     */
    private Long accountId;

    /**
     * 绑定广告名称
     */
    private String advertName;

    /**
     * 外部平台扩展的用于区分同账号的groupid
     * 例如：爱奇艺那边是type
     * 360那边是推广告组id
     */
    private Long extGroupId;

    /**
     * 绑定的广告主名称
     */
    private String advertiserName;
    /**
     * 广告主id
     */
    private String advertiserId;


    /**
     * 出价方式 CPC/CPM
     */
    private String bidWay;

    /**
     * 出价
     */
    private Long fee;

    /**
     * 1 开启 0关闭
     */
    private Integer openStat;
    /**
     * 1 删除 0未删除
     */
    private Integer delStat;

    /**
     * 屏蔽兴趣标签
     * ，分隔
     */
    private String sheildInterestTags;
    /**
     * 定向兴趣标签。
     * ，分隔
     */
    private String targetedInterestTags;

}