package cn.com.tuia.advert.enums;



/**
 * 
 * ClassName: DisAppFeeTypeEnum <br/>
 * Function: 分媒体出价的类型. <br/>
 * date: 2019年4月30日 下午2:58:50 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum DisAppFeeTypeEnum {
    
 
    
    DEFULT_TYPE(0,"无替换出价"),
    
    SIGN_FOR_APP_TYPE(1,"优化目标为签收的分媒体出价：系统托管ocpc+优化目标（签收）+优化目标（人工定向）"),
    
    IMPORTANT_APP_TYPE(2,"重点媒体转化出价：系统托管ocpc+优化目标（落地页，注册，激活）+投放目标（消耗优先，成本优先，均衡投放）"),
    
    ORDINARY_APP_CPC_TYPE(3,"普通的分媒体转化出价：人工投放cpc+未开启潜力广告扶持"),
    
    ORDINARY_APP_CPA_TYPE(4,"普通的分媒体转化出价：系统托管ocpc+优化目标（落地页，注册，激活）+投放目标（人工定向）"),

    POTENTIAL_APP_TYPE(5,"潜力广告扶持分媒体出价：人工投放cpc+开启潜力广告扶持"),

    POTENTIAL_APP_OVER_TYPE(6,"潜力广告扶持结束后分媒体出价：人工投放cpc+潜力广告扶持结束");


    /** 代码 */
    private Integer code;
    /** 描述 */
    private String desc;

    private DisAppFeeTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static DisAppFeeTypeEnum getByCode(Integer code){
        for(DisAppFeeTypeEnum enumVal : DisAppFeeTypeEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }
    
    /**
     * 
     * getByType:(获取分媒体出价类型). <br/>
     *
     * @author chencheng
     * @param subtype 优化目标 @AdvertSubtypeEnum
     * @param packageType 包的类型 1-人工包，2-系统托管包
     * @param chargeType 计费方式,当前仅有：1.CPC;2.CPA @ChargeTypeEnum
     * @param targetAppLimit 投放模式，1-人工包，2-自动模式，3-优投模式 todo 7878 调用这个方法的引擎都要改
     * @param potentialType 是否开启潜力广告扶持，0-否、1-是
     * @return
     * @since JDK 1.8
     */
    public static DisAppFeeTypeEnum getByType(Integer subtype, Integer packageType, Integer chargeType, Integer targetAppLimit, Integer potentialType){
        
        if (packageType == null || chargeType == null) {
            return DEFULT_TYPE;
        }
        // 人工包
        if (PackageTypeEnum.INTERACTIVE_TYPE.getCode().equals(packageType)){

            // 人工包只有cpc, 只判断潜力广告开启类型
            if (potentialType == null || SwitchTypeEnum.CLOSE_TYPE.getCode() == potentialType.intValue()) {
                return ORDINARY_APP_CPC_TYPE;
            }

            if(potentialType == 1){
                return POTENTIAL_APP_TYPE;
            }

            if(potentialType > 1){
                return POTENTIAL_APP_OVER_TYPE;
            }

            return ORDINARY_APP_CPC_TYPE;
        }
        /** 剩下的为系统托管包 */
        //cpc不能设置
        if (ChargeTypeEnum.TYPE_CPC.getCode() == chargeType.intValue()) {
            return DEFULT_TYPE;
        }
        /** 以下为系统托管包ocpc */
        //优化目标枚举
        AdvertSubtypeEnum subtypeEnum = AdvertSubtypeEnum.getBySubtype(subtype);
        switch (subtypeEnum) {
            case SIGN_FOR:
                if (PutTargetTypeEnum.manual_target.getTargetAppLimit().equals(targetAppLimit)) {
                    return SIGN_FOR_APP_TYPE;
                }
                return DEFULT_TYPE;
                
            case CVR:
            case START:
            case REGISTER:
                if(targetAppLimit == null){
                    return DEFULT_TYPE;
                }else if (PutTargetTypeEnum.manual_target.getTargetAppLimit().equals(targetAppLimit)) {
                    return ORDINARY_APP_CPA_TYPE;
                }
                return IMPORTANT_APP_TYPE;
                
            default:
                return DEFULT_TYPE;
        }
        
    }

    
    
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
