package cn.com.tuia.advert.enums.userinfo;

import cn.com.tuia.advert.enums.PlatformTypeEnum;
import cn.com.tuia.advert.enums.UserResourceEnum;
import com.google.common.collect.Maps;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 工作状态枚举类
 * @date 2019/8/1 10:32
 */
public enum WorkStateEnum {


    /**
     * 学生
     */
    STUDENT(0,"student"),


    /**
     * 工作状态
     */
    WROK(1,"work"),


    /**
     * 其他状态
     */
    WORKOTHER(2,"workother");

    private int code;

    private String desc;

    WorkStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, WorkStateEnum> enumMap = Maps.newHashMap();

    static {
        for (WorkStateEnum it : WorkStateEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static WorkStateEnum getByCode(Integer code) {
        WorkStateEnum workStateEnum = enumMap.get(code);
        return workStateEnum == null ? WorkStateEnum.WORKOTHER : workStateEnum;
    }

}
