package cn.com.tuia.advert.Tool;

import java.util.Map;

public class PkgPutTargetTypeByWhite {

    //优投模式
    private static final Integer OPTIMAL_MODE = 3;

    /**
     * 如果在白名单内，替换投放目标
     * @param smartCompatibleMap key：配置ID，value:投放目标
     * @param targetAppLimit 投放模式(定向模式，2-自动模式，3-优投模式)
     * @param initialOrientationId 原始配置ID
     * @param putTargetType 投放目标
     * @return
     */
    public static Integer coverPkgPutTargetTypeByWhite(Map<Long, Integer> smartCompatibleMap, Integer targetAppLimit, Long initialOrientationId, Integer putTargetType) {

        //如果白名单为空，则直接返回本来的
        if (smartCompatibleMap.isEmpty()) {
            return putTargetType;
        }

        //如果配置是优投模式（人工定向）
        if (OPTIMAL_MODE.equals(targetAppLimit)) {

            // 且在白名单内
            Integer result = smartCompatibleMap.get(initialOrientationId);
            if (result != null) {
                return result;
            }

        }
        return putTargetType;

    }
}
