package cn.com.tuia.advert.enums;

/**
 * 广告过滤顾类型枚举
 *
 * @author peanut.huang
 * @date 2019/4/10
 * @since JDK 1.8
 */
public enum AdvertFilterTypeEnum {

    /**
     *
     */
    ACTIVITY_TYPE("1.1.1.0", "投放的活动类型"),
    JOIN_NUM("1.1.2.0", "发券顺序"),
    PERIOD("1.1.3.0", "投放时段"),
    BUDGET_PER_DAY("1.1.4.0", "配置日预算"),

    USER_INTEREST("1.2.1.0", "定向人群"),
    SEX("1.2.2.0", "性别"),
    AGE_REGION("1.2.3.0", "年龄区间"),
    WORK_STATE("1.2.4.0", "工作状态"),
    REGION("1.2.5.0", "投放地域"),
    ADX_ORIENT_DATA("1.2.6.0", "adx定向数据"),
    DEVICE("1.2.7.0", "设备号定向"),

    TARGET_APP("1.3.1.0", "定向媒体"),
    LIMIT_APP("1.3.2.0", "限流媒体"),
    BANNED_APP_FLOW("1.3.3.0", "屏蔽流量"),
    BANNED_TAG("1.3.4.0", "屏蔽标签"),
    BANNED_INDUSTRY_TAG("1.3.4.1", "屏蔽行业标签"),
    BANNED_RESOURCE_TAG("1.3.4.2", "屏蔽资源标签"),
    BANNED_ATTRIBUTE_TAG("1.3.4.3", "屏蔽属性标签"),
    BANNED_PROMOTEURL_TAG("1.3.4.4", "屏蔽落地页标签"),
    BANNED_MATERIAL_TAG("1.3.4.5", "屏蔽素材标签"),
    BANNED_URL("1.3.5.0", "屏蔽落地页链接"),
    SPECIAL_APP("1.3.6.0", "特殊广告媒体过滤"),
    SELECT_ADVERT("1.3.7.0", "媒体广告互选"),
    TURN_TAG("1.3.8.0", "轮投标签"),
    TARGET_ACTIVITY("1.3.9.0", "定向活动"),
    SLOT_BLACKLIST("1.3.10.0", "媒体广告位黑名单"),
    SLOT_KEYWORD("1.3.11.0", "媒体广告位关键词过滤"),
    IQIYI_URL_FILTER("1.3.12.0", "爱奇艺URL过滤"),
    CHOOSE_ADVERT("1.3.13.0", "广告位定制可投广告"),

    PLATFORM("1.4.1.0", "操作平台系统"),
    NETWORK_TYPE("1.4.2.0", "网络类型"),
    OPERATORS("1.4.3.0", "网络运营商"),
    BRAND_NAME("1.4.4.0", "设备品牌"),
    BRAND_LEVEL("1.4.5.0", "设备价值"),
    TRANSFORM_PEOPLE("1.4.6.0","已转化人群过滤"),


    REPEAT_LUNCH("1.5.0.0", "重复发券"),
    REPEAT_EXPOSURE("1.5.1.0", "重复曝光"),

    ACTIVITY_ADVERT("2.1.0.0", "活动定制广告"),
    ACTIVITY_WHITE("2.2.0.0", "活动白名单"),
    APP_WHITE("2.3.0.0", "媒体白名单"),
    NEW_APP_TEST("2.4.0.0", "新媒体测试"),
    DMP_TEST("2.5.0.0", "DMP测试"),
    BLOCK_WHITELIST("2.6.0.0", "区块白名单"),
    BID_FLOOR("2.7.0.0", "底价过滤"),
    LOW_NEEDS_AD("2.8.0.0","用户低意向广告过滤"),

    BEFORE_RECOMMEND("3.1.0.0", "推荐之前"),
    RECOMMEND_FAILED("3.2.0.0", "竞价失败"),
    UNKNOW("3.3.0.0", "未知"),

    URGENT_ADVERT("4.1.1.0","应急广告填充" ),
    ACTIVITY_MATERIAL_TYPE("5.1.1.0","活动素材类型"),
    VIDEO_MATERIAL_TYPE("5.2.1.0","激励视频素材类型"),

    ACTIVITY_PRE_TYPE_NEW_TRADE_TAG("6.1.1.0","新行业标签"),
    ACTIVITY_PRE_TYPE_ADX("6.1.2.0","活动预发券"),

    MICRO_PROGRAM_AB_TEST("7.1.1.0","小程序ab测试"),
    NET_CARRIER_AB_TEST("7.1.1.1","三网识别ab测试"),
    QUICK_APP("7.1.1.2", "快应用ab测试"),
    MEDIA_TAG("7.1.1.3","媒体回传标签测试"),

    USER_ACTION("8.1.1.0", "用户行为过滤"),
    ;

    private String code;

    private String desc;

    AdvertFilterTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
