package cn.com.tuia.advert.enums;

import java.util.Objects;

/**
 * [广告分媒体调控]生效条件枚举
 *
 * @author zhangbaiqiang
 * @date 2020/8/6
 */
public enum LayeredStrategyConditionEnum {

    ADVERTISER_LANDPAGE(1, "广告主落地页"),
    BAIQI_LANDPAGE(2, "百奇落地页");

    private Integer type;
    private String desc;

    LayeredStrategyConditionEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        return Objects.equals(type, ADVERTISER_LANDPAGE.type) ? ADVERTISER_LANDPAGE.desc : BAIQI_LANDPAGE.desc;
    }
}
