package cn.com.tuia.advert.service;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.tuia.advert.model.*;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月01日 09:50
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface IAdvertDirectService {

    /**
     * 获取有效的广告 给活动管理端调用
     * @param advertIds 需要过滤的广告列表
     * @return
     */
    @RequestMapping("/getValidAdvertsById")
    DubboResult<List<AdvertDirectDto>> getValidAdverts(List<Long> advertIds);


    /**
     * 获取有效的广告
     * @param directObtainAdvertReq
     * @return
     */
    @RequestMapping("/getValidAdvertsByReq")
    DubboResult<List<AdvertDirectDto>> getValidAdverts(DirectObtainAdvertReq directObtainAdvertReq);

    /**
     * 发券-直投广告
     * @param req
     * @return
     */
    DubboResult<Boolean> directAdvert(DirectAdvertLogReq req);

    /**
     * 打印曝光发券日志-激励视屏直投广告
     */
    Boolean showLog(DirectAdvertLogReq req);

    /**
     * 打印点击日志-激励视屏直投广告
     */
    Boolean clickLog(DirectAdvertLogReq req);
}
