package cn.com.tuia.advert.enums.userinfo;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @author Wangpf
 * @description 性别枚举类
 * @date 2019/7/31 17:46
 */
public enum SexEnum {

    /**
     * 女
     */
    FEMALE(0, "female"),

    /**
     * 男
     */
    MALE(1, "male"),


    /**
     * 不限性别
     */
    NO_LIMIT(2, null);

    private int code;

    private String desc;

    SexEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static Optional<String> getSexByCode(int code) {
        for (SexEnum value : SexEnum.values()) {
            //这里为了兼容性别活动不传性别的情况
            if (value.getCode() == code && code != NO_LIMIT.getCode()) {
                return Optional.of(value.getDesc());
            }
        }
        return Optional.empty();
    }

    /**
     * 判断当前性别是否在正常范围 1 or 0 or null
     *
     * @param code
     * @return
     */
    public static boolean isCorrect(Integer code) {
        return Stream.of(SexEnum.values()).map(SexEnum::getCode).anyMatch(temp -> Objects.equals(code, temp));
    }

}
