package cn.com.duiba.user.service.api.enums.liveuser;


public enum BizTypeApiEnum {

    KJJ(1, "客集集"),
    ;

    private Integer code;
    private String value;

    BizTypeApiEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public Integer getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }

    /**
     * 根据编码查询枚举。
     *
     * @param code 编码。
     * @return 枚举。
     */
    public static BizTypeApiEnum getByCode(Integer code) {
        for (BizTypeApiEnum value : BizTypeApiEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    /**
     * 枚举是否包含此code
     *
     * @param code 枚举code
     * @return 结果
     */
    public static Boolean contains(Integer code) {
        for (BizTypeApiEnum value : BizTypeApiEnum.values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

}
