package cn.com.duiba.user.service.api.enums.oa;

import cn.com.duiba.user.service.api.enums.user.UserExtTypeEnum;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum {
    CONTENT_MAIN_OA(1,"内容主体公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.OA;
        }
    },
    VIP_OA(2,"付费用户的VIP专属公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIP;
        }
    },
    MP(3,"客集集主体小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.MP;
        }
    },
    CLIENT_PUSH_MP(4,"客户接收私信消息的小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.CLIENT_MP;
        }
    },

    FISSION_MP(5,"微信裂变小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.FISSION_MP;
        }
    },

    GAME_MP(6,"抽奖模板小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.GAME_MP;
        }
    },

    GREETING_MP(7,"节日贺卡小程序"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.GREETING_MP;
        }
    },

    INNER_SALE(8,"内部销售web应用"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return null;
        }
    },
    LIVE_USER_MP(9, "直播用户端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    LIVE_ANCHOR_MP(10, "直播主端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_ANCHOR_MP;
        }
    },

    OPEN_PL(11,"第三方服务平台") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂无用户
            return null;
        }
    },

    OPEN_OA(12,"第三方服务平台服务的公众号") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            //暂不保存用户
            return UserExtTypeEnum.LIVE_OA;
        }
    },

    OPEN_MP(13, "第三方服务平台服务的小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    PROXY_LIVE_USER_MP(14, "代理小程序") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    }

    ;
    private Integer type;
    private String desc;

    OATypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final List<Integer> MP_TYPE_LIST = new ArrayList<>();

    static {
        MP_TYPE_LIST.add(MP.getType());
        MP_TYPE_LIST.add(CLIENT_PUSH_MP.getType());
        MP_TYPE_LIST.add(FISSION_MP.getType());
        MP_TYPE_LIST.add(GAME_MP.getType());
        MP_TYPE_LIST.add(GREETING_MP.getType());
        MP_TYPE_LIST.add(LIVE_USER_MP.getType());
        MP_TYPE_LIST.add(LIVE_ANCHOR_MP.getType());
        MP_TYPE_LIST.add(OPEN_MP.getType());
        MP_TYPE_LIST.add(PROXY_LIVE_USER_MP.getType());
    }

    public static boolean isMp(Integer type) {
        if (type == null) {
            return false;
        }
        return MP_TYPE_LIST.contains(type);
    }

    public boolean isMp() {
        return this == MP || this == CLIENT_PUSH_MP || this == FISSION_MP || this == GAME_MP || this == GREETING_MP;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();
}
