package cn.com.duiba.user.service.api.enums;


import cn.com.duiba.kjy.base.api.request.ErrorCodeInterface;

/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //通用
    DATE_ERROR("990001","数据错误"),
    GET_LOCK_FAIL("990002", "获取分布式锁失败"),
    SYSTEM("999999","系统错误"),

    //02 用户模块
    N020001("020001","保存用户信息错误"),
    N020002("020002","保存用户扩展信息错误"),
    N020003("020003","更新用户信息错误"),
    N020004("020004","保存用户扩展信息错误"),
    N020005("020005","更新用户扩展信息错误"),
    N020006("020006","保存删除用户信息错误"),
    N020007("020007","更新用户信息为删除用户时错误"),


    /**
     * 企微
     */
    PROVIDER_CORP_PARAM_ERROR("030001","初始化企微服务商参数错误"),
    CORP_SUIT_PARAM_ERROR("030002","初始化企微服务商应用参数错误"),
    SUIT_AUTH_PARAM_ERROR("030002","初始化应用授权企微服务商参数错误"),

    CORP_USER_INSERT_ERROR("030101","企微用户保存失败"),
    CORP_USER_INSERT_USERS_ERROR("030102","企微用户插入主表失败"),
    CORP_USER_INSERT_EXT_ERROR("030103","企微用户插入企微扩展信息失败"),
    CORP_NOT_EXIST("030104","企微账号不存在"),
    MP_NOT_EXIST("030105","小程序不存在"),
    CORP_USER_INSERT_MP_ERROR("030103","企微用户插入小程序扩展信息失败"),

    /**
     * 测试专区
     */
    USER_NOT_EXIST("260001", "用户不存在或数据不正确"),
    OA_UN_SUBSCRIBE("260002","未取关公众号"),
    NOT_IN_ALLOW_COMPANY_LIST("260003", "该公司下账号不允许禁用")


    ;

    private final String shortCode;
    private final String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "US";
    }

    @Override
    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
