package cn.com.duiba.user.service.api.dto.third;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 直播第三方用户关联表
 *
 * @author kjj mybatis generator
 * 2023-03-03
 */
@Data
public class LiveThirdUserDto implements Serializable {
    private static final long serialVersionUID = 16778262083605452L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户id tb_users.id
     */
    private Long userId;

    /**
     * 用户id tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 第三方用户id third_type=1 表示中信公众号openId
     * max length = 64
     */
    private String thirdUserId;

    /**
     * 第三方类型 1-中信信用卡
     * {@link cn.com.duiba.user.service.api.enums.third.ThirdUserTypeEnum}
     */
    private Integer thirdType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}