package cn.com.duiba.user.service.api.dto.wxwork;

import cn.com.duiba.user.service.api.enums.wxwork.WxWorkCorpTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企微账号主表
 * @author kjj mybatis generator
 * 2021-11-22
 */
@Data
public class WxWorkCorpDto implements Serializable {
    private static final long serialVersionUID = 1637568417841842L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *企微账号类型 1:第三方企微账号 2:服务商账号
     * {@link WxWorkCorpTypeEnum}
     */
    private Integer corpType;

    /**
     *
     *企微账号，对应企微的corpid
     * max length = 128
     */
    private String corpKey;

    /**
     *
     *企微账号的名称
     * max length = 64
     */
    private String corpName;

    /**
     *
     *企微账号logo的二维码地址
     * max length = 255
     */
    private String logoUrl;

    /**
     * 状态
     */
    private Integer corpState;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;
}
