package cn.com.duiba.user.service.api.dto.wxwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企微服务应用表
 * @author kjj mybatis generator
 * 2021-11-22
 */
@Data
public class WxWorkSuiteDto implements Serializable {
    private static final long serialVersionUID = 16375684178396755L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *所属服务商，tb_corp表的ID
     */
    private Long corpId;

    /**
     *
     *服务商应用账号，对应企微的suit_id
     * max length = 128
     */
    private String suiteKey;

    /**
     *
     *应用的secret
     * max length = 64
     */
    private String suiteSecret;

    /**
     *
     *获取accessToken的密钥
     * max length = 255
     */
    private String suiteTicket;

    /**
     *
     *服务商应用名称
     * max length = 64
     */
    private String suiteName;

    /**
     *
     *服务商应用logo的二维码地址
     * max length = 255
     */
    private String logoUrl;

    /**
     * 状态
     * @see  cn.com.duiba.user.service.api.enums.wxwork.WxWorkStatusEnum
     */
    private Integer suiteState;

    /**
     * 应用类型：
     * @see cn.com.duiba.user.service.api.enums.wxwork.SuiteSourceEnum
     */
    private Integer suiteSource;
    /**
     * 对应企微的agentid。当应用为自建应用时有值，服务商应用在企业授权后记录在tb_wxwork_corp_suite表
     */
    private String agentKey;
    /**
     * 应用类型：1:网页 2:小程序
     * @see cn.com.duiba.user.service.api.enums.wxwork.SuiteTypeEnum
     */
    private Integer suiteType;

    /**
     * 应用的业务场景。
     * @see cn.com.duiba.user.service.api.enums.wxwork.SuiteSceneEnum
     */
    private Integer suiteScene;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;
}
