package cn.com.duiba.user.service.api.param.oa;

import cn.com.duiba.user.service.api.param.PageQuery;
import lombok.Data;

import java.util.List;

/**
 * 公众号查询参数
 * @author 吴文哲
 * @date 2020/11/24 11:57 上午
 **/
@Data
public class OfficialAccountParam extends PageQuery {
    private static final long serialVersionUID = -2594331720413634593L;

    /**
     * 是否启用
     * @see cn.com.duiba.user.service.api.enums.oa.IsOpenEnum
     */
    private Integer oaEnable;

    /**
     * 公众号类型
     * @see cn.com.duiba.user.service.api.enums.oa.OATypeEnum
     */
    private Integer oaType;

    /**
     * 公众号是否可见
     * @see cn.com.duiba.user.service.api.enums.oa.OaVisibleEnum
     */
    private Integer oaVisible;

    /**
     * 公众号类型列表
     * @see cn.com.duiba.user.service.api.enums.oa.OATypeEnum
     */
    private List<Integer> oaTypes;
}
