package cn.com.duiba.user.service.api.remoteservice.third;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.third.LiveThirdUserDto;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2023/3/3 15:27
 **/
@AdvancedFeignClient
public interface RemoteLiveThirdUserService {

    /**
     * 根据第三方用户id和第三方类型查询
     *
     * @param thirdUserId 第三方用户id
     * @param thirdType   第三方类型 {@link cn.com.duiba.user.service.api.enums.third.ThirdUserTypeEnum}
     * @return 第三方用户
     */
    LiveThirdUserDto selectByThirdUserIdAndType(String thirdUserId, Integer thirdType);

    /**
     * 根据第三方用户id和第三方类型批量查询
     *
     * @param thirdUserIds 第三方用户id集合
     * @param thirdType 第三方类型 {@link cn.com.duiba.user.service.api.enums.third.ThirdUserTypeEnum}
     * @return 第三方用户集合
     */
    List<LiveThirdUserDto> selectByThirdUserIdsAndType(List<String> thirdUserIds, Integer thirdType);

    /**
     * 根据直播用户id和第三方类型批量查询
     *
     * @param liveUserIds 直播用户id集合
     * @param thirdType 第三方类型 {@link cn.com.duiba.user.service.api.enums.third.ThirdUserTypeEnum}
     * @return 第三方用户集合
     */
    List<LiveThirdUserDto> selectByLiveUserIdsAndType(List<Long> liveUserIds, Integer thirdType);

    /**
     * 更新
     *
     * @param dto 第三方用户
     * @return 结果
     */
    int update(LiveThirdUserDto dto);

    /**
     * 新增
     *
     * @param dto 第三方用户
     * @return 结果
     */
    int insert(LiveThirdUserDto dto);

    /**
     * 批量插入
     *
     * @param list 第三方用户
     * @return 结果
     */
    int batchInsert(List<LiveThirdUserDto> list);
}
