package cn.com.duiba.user.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Set;

/**
 * @author dugq
 * @date 2022/4/6 8:16 下午
 *
 * 企微小程序应用和个微小程序关联关系
 *
 * 举例：
 * 直播小程序，它是tb_wx_work_suite中的一个应用，也是tb_official_account中的一个账号，
 * 它是同一个东西跨越了两个平台，两个平台毫无关联，
 * 但对于直播业务，他们是关联的，代理人使用企微应用，访客使用个微小程序
 */
@AdvancedFeignClient
public interface RemoteWxWorkMpSuiteService {

    /**
     * 根据应用ID查询oaID
     * @param suiteId 应用ID
     * @return null表示未配置
     */
    Long getOaIdBySuiteId(Long suiteId);

    /**
     * 根据oaID查询应用ID
     * @param oaId oaId
     * @return null表示未配置
     */
    Long getSuiteIdByOaId(Long oaId);

    /**
     * 查询已经配置使用的小程序列表
     */
    Set<Long> getOnlineMpOaList();

    /**
     * 查询已经配置使用的应用列表
     */
    Set<Long> getOnlineMpSuiteList();
}
