package cn.com.duiba.user.service.api.enums.user;

import lombok.Getter;

/**
 * 用户分组
 * 场景：
 * 1。有unionId时，是登陆场景使用
 * 2。没有unionId时，比如其他系统使用，则使用userId区分用户分组
 * @author dugq
 * @date 2021/7/19 2:39 下午
 */
@Getter
public enum UserGroupEnum {
    A("A","加密unionId/userId尾号为基数的用户"),
    B("B","加密unionId/userId尾号为偶数的用户");

    private String type;
    private String desc;

    UserGroupEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据用户unioncode 最后一位获取用户类型
     * @param c unioncode最后一位
     * @return 用户类型
     */
    public static UserGroupEnum getByLastCharOfUnionCode(char c) {
        if (c % 2 ==0){
            return B;
        }else{
            return A;
        }
    }

    /**
     * 根据用户id获取用户类型
     * @param userId 用户id
     * @return 用户类型
     */
    public static UserGroupEnum getByLiveUserId(Long userId) {
        if (userId % 2 ==0){
            return B;
        }else{
            return A;
        }
    }
}
