package cn.com.duiba.user.service.api.param.wxwork;

/**
 * @author dugq
 * @date 2021/11/22 8:29 下午
 */

import lombok.Data;

import java.io.Serializable;

@Data
public class WxWorkInitSuiteParam implements Serializable {
    private static final long serialVersionUID = 1076609646300072177L;
    /**
     *
     *所属服务商，tb_corp表的ID
     */
    private Long corpId;

    /**
     *
     *服务商应用账号，对应企微的suit_id
     * max length = 128
     */
    private String suiteKey;

    /**
     *
     *应用的secret
     * max length = 64
     */
    private String suiteSecret;

    /**
     *
     *服务商应用名称
     * max length = 64
     */
    private String suiteName;

    /**
     *
     *服务商应用logo的二维码地址
     * max length = 255
     */
    private String logoUrl;

    /**
     * 应用类型：1:网页 2:小程序
     * @see cn.com.duiba.user.service.api.enums.wxwork.SuiteTypeEnum
     */
    private Integer suiteType;

    /**
     * 应用的业务场景。
     * @see cn.com.duiba.user.service.api.enums.wxwork.SuiteSceneEnum
     */
    private Integer suiteScene;

    /**
     * 接口回调加密token
     */
    private String encodeToken;

    /**
     * 接口回调aes加密密钥
     */
    private String encodeAesKey;
}
