package cn.com.duiba.user.service.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.app.AppCorpDto;
import cn.com.duiba.user.service.api.dto.app.AppCorpSaveResultDto;
import cn.com.duiba.user.service.api.param.app.SaveAppCorpParam;

/**
 * 客户app配置相关
 * @author lizhi
 * @date 2021/12/2 1:37 下午
 */
@AdvancedFeignClient
public interface RemoteAppCorpApiService {

    /**
     * 保存客户app配置
     * @param param 保存参数
     * @return 结果
     */
    AppCorpSaveResultDto save(SaveAppCorpParam param);

    /**
     * 根据唯一标识查询（走redis缓存）
     * @param appId app唯一标识
     * @return 客户app配置
     */
    AppCorpDto selectByAppIdCache(String appId);
}
