package cn.com.duiba.user.service.api.remoteservice.user.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.user.app.UserAppCorpDto;

/**
 * 客户app用户扩展相关
 * @author lizhi
 * @date 2021/12/1 2:48 下午
 */
@AdvancedFeignClient
public interface RemoteUserAppCorpApiService {

    /**
     * 根据唯一约束查询（走redis缓存）
     * @param appCorpId 客户app企业配置ID，对应tb_app_corp.id
     * @param appUserId 客户app用户ID，由第三方传入
     * @return 客户app扩展信息
     */
    UserAppCorpDto selectByUniqueKeyCache(Long appCorpId, String appUserId);
}
