package cn.com.duiba.user.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.user.service.api.dto.wxwork.WxWorkSuiteDto;
import cn.com.duiba.user.service.api.param.wxwork.WxWorkInitSuiteParam;
import cn.com.duiba.user.service.api.param.wxwork.RefreshSuiteTicketParam;

/**
 * 企微服务商账号下的应用相关操作
 * @author dugq
 * @date 2021/11/23 10:54 上午
 */
@AdvancedFeignClient
public interface RemoteWxWorkSuiteService {

    /**
     * 刷新ticket
     */
    boolean refreshTicket(RefreshSuiteTicketParam param);

    /**
     * 根据ID查询
     */
    WxWorkSuiteDto selectOne(Long id);

    /**
     * 根据suitKey 对应微信的suitid查询
     */
    WxWorkSuiteDto selectByKey(String suitKey);

    /**
     * 初始化一个新的suit
     */
    long initSuit(WxWorkInitSuiteParam initParam);
}
