package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 客服消息子类型
 *
 * @author: zdq
 * @create: 2020/10/09
 **/
public enum ConsumerMsgPushStatusEnum {

    FAIL("0", "失败"),
    SUCCESS("1", "成功");

    String code;
    String desc;

    ConsumerMsgPushStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, ConsumerMsgPushStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ConsumerMsgPushStatusEnum pushEnum : values()) {
            ENUM_MAP.put(pushEnum.getCode(), pushEnum);
        }
    }

    public static ConsumerMsgPushStatusEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
