package cn.com.duiba.wechat.server.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2019/7/25 16:51
 */
public enum SubscribeEnum {

    /**
     * 用户关注状态
     */
    SUBSCRIBE("1", "关注"),

    UNSUBSCRIBE("0", "未关注"),
    ;

    private String type;

    private String desc;

    SubscribeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<String, SubscribeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SubscribeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static SubscribeEnum getByCode(String code) {
        return ENUM_MAP.get(code);
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
