package cn.com.duiba.wechat.server.api.param;

import cn.com.duiba.boot.exception.BizException;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2020/8/18 13:59
 */
public class RequestCheckUtils {
    private static final String ERROR_CODE_ARGUMENTS_MISSING = "40";
    private static final String ERROR_CODE_ARGUMENTS_INVALID = "41";

    private RequestCheckUtils(){
        throw new IllegalStateException("Utility class");
    }

    public static void checkNotEmpty(Object value, String fieldName) throws BizException {
        if (value != null) {
            if (value instanceof String && ((String) value).trim().length() == 0) {
                throw new BizException("client-error:Missing required arguments:" + fieldName + "").withCode(ERROR_CODE_ARGUMENTS_MISSING);
            }
        } else {
            throw new BizException("client-error:Missing required arguments:" + fieldName + "").withCode(ERROR_CODE_ARGUMENTS_MISSING);
        }
    }

    public static void checkMaxLength(String value, int maxLength, String fieldName) throws BizException {
        if (value != null && value.length() > maxLength) {
            throw new BizException("client-error:Invalid arguments:the string length of " + fieldName + " can not be larger than " + maxLength + ".").withCode(ERROR_CODE_ARGUMENTS_INVALID);
        }
    }


    public static void checkMaxListSize(String value, int maxSize, String fieldName) throws BizException {
        if (value != null) {
            String[] list = value.split(",");
            if (list.length > maxSize) {
                throw new BizException("client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".").withCode(ERROR_CODE_ARGUMENTS_INVALID);
            }
        }

    }

    public static void checkMaxListSize(List<String> list, int maxSize, String fieldName) throws BizException {
        if (list != null && list.size() > maxSize) {
            throw new BizException("client-error:Invalid arguments:the array size of " + fieldName + " must be less than " + maxSize + ".").withCode(ERROR_CODE_ARGUMENTS_INVALID);
        }
    }


    public static void checkMaxValue(Long value, long maxValue, String fieldName) throws BizException {
        if (value != null && value > maxValue) {
            throw new BizException("client-error:Invalid arguments:the value of " + fieldName + " can not be larger than " + maxValue + ".").withCode(ERROR_CODE_ARGUMENTS_INVALID);
        }
    }

    public static void checkMinValue(Long value, long minValue, String fieldName) throws BizException {
        if (value != null && value < minValue) {
            throw new BizException("client-error:Invalid arguments:the value of " + fieldName + " can not be less than " + minValue + ".").withCode(ERROR_CODE_ARGUMENTS_INVALID);
        }
    }
}