package cn.com.duiba.wechat.server.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wechat.server.api.param.WxTemplateManualPushParam;

import java.util.List;

/**
 * @description:
 * @author: liupu1
 * @create: 2020/8/14 11:06 AM
 **/
@AdvancedFeignClient
public interface RemoteWxTemplateMsgPushService {

    /**
     * 定时任务对任务进行全量扫描和推送
     * @return
     */
    Boolean autoPushTemplateMsg();

    /**
     * 手动推送制定模板的推送任务
     * @param param
     * @return
     */
    Boolean manualPushTemplateMsg(WxTemplateManualPushParam param) throws BizException;

    /**
     * 从微信手动拉取用户进行用户推送
     * @param ruleId 规则ID
     * @param openIds 拉取的openId，不能超过100条，注意sleep
     */
    void pushUserMsgByOpenIds(Long ruleId, List<String> openIds);

    boolean manualPushMsgExceptSpecialTime(WxTemplateManualPushParam param) throws BizException;
}
