package cn.com.duiba.wolf.utils;

import org.apache.commons.lang.StringUtils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by wenqi.huang on 16/4/8.
 */
public class NumberUtils {

    public static int parseInt(String str, int defaultValue) {
        if (StringUtils.isEmpty(str)) {
            return defaultValue;
        }
        int value;
        try {
            value = Integer.parseInt(str.trim());
        } catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static float parseFloat(String str, float defaultValue) {
        if (StringUtils.isEmpty(str)) {
            return defaultValue;
        }
        float value;
        try {
            value = Float.parseFloat(str.trim());
        } catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static long parseLong(String str, long defaultValue) {
        if (StringUtils.isEmpty(str)) {
            return defaultValue;
        }
        long value;
        try {
            value = Long.parseLong(str.trim());
        } catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static double parseDouble(String str, double defaultValue) {
        if (StringUtils.isEmpty(str)) {
            return defaultValue;
        }
        double value;
        try {
            value = Double.parseDouble(str.trim());
        } catch (Exception e) {
            value = defaultValue;
        }
        return value;
    }

    public static Long add(Long val1, Long val2) {
        Long tmpval1 = val1 != null ? val1 : 0;
        Long tmpval2 = val2 != null ? val2 : 0;
        return tmpval1.longValue() + tmpval2.longValue();
    }

    public static Integer add(Integer val1, Integer val2) {
        Integer tmpval1 = val1 != null ? val1 : 0;
        Integer tmpval2 = val2 != null ? val2 : 0;
        return tmpval1.intValue() + tmpval2.intValue();
    }

    public static Double add(Double val1, Double val2) {
        Double tmpval1 = val1 != null ? val1 : 0D;
        Double tmpval2 = val2 != null ? val2 : 0D;
        return tmpval1.doubleValue() + tmpval2.doubleValue();
    }

    public static String numberFormat(double f, int fractionDigits) {
        NumberFormat nf1 = NumberFormat.getInstance(Locale.CHINA);
        nf1.setMaximumFractionDigits(fractionDigits);
        return nf1.format(f);
    }

    public static String numberFormat(float n, int digs) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(digs);
        return nf.format(n);
    }

    public static String numberFormat(double f) {
        NumberFormat nf1 = NumberFormat.getInstance(Locale.CHINA);
        return nf1.format(f);
    }

    public static String percentFormat(double d) throws ParseException {
        DecimalFormat nf = (DecimalFormat) NumberFormat.getPercentInstance();
        nf.applyPattern("##.##%");
        return nf.format(d);
    }

    public static String getPercent(int x, int total, boolean type) {
        String result = "0%";// 接受百分比的值
        double tempresult = x * 1.0 / total;
        DecimalFormat df1 = new DecimalFormat("0%"); // ##.00% 百分比格式，后面不足2位的用0补齐
        result = df1.format(tempresult);
        if (type) {
            result = result.replace("%", "");
        }
        return result;
    }

    public static boolean isNumeric(String str){
        if(StringUtils.isBlank(str)){
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        if( !isNum.matches() ){
            return false;
        }
        return true;
    }

    public static String numberFormat(long number){
        return DecimalFormat.getNumberInstance().format(number);
    }

}
