package cn.com.duiba.wolf.utils;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by wenqi.huang on 16/5/3.
 * 测试工具类
 */
public class TestUtils {
    private TestUtils(){}

    /**
     * 创建随机的bean,实例化一个类（要求该类拥有默认构造函数）,并赋予该类的各个变量以随机值.方便测试(该方法不会给父类中的属性赋值)
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T createRandomBean(Class<T> clazz){
        return createRandomBean(clazz,false);
    }

    /**
     * 创建随机的bean,实例化一个类（要求该类拥有默认构造函数）,并赋予该类的各个变量以随机值.方便测试
     * @param clazz
     * @param <T>
     * @param includeParents 父类中的变量是否赋值
     * @return
     */
    public static <T> T createRandomBean(Class<T> clazz, boolean includeParents){
        T t = null;
        try {
            t = (T)clazz.newInstance();

            setRandomAttributesForBean(t, includeParents);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }

        return t;
    }

    /**
     * 给某个对象的属性设置随机值,方便测试
     * @param t
     * @param includeParents
     * @throws IllegalAccessException
     */
    public static void setRandomAttributesForBean(Object t, boolean includeParents) throws IllegalAccessException {
        setRandomAttributesForBean(t, t.getClass(), includeParents,false);
    }

    /**
     *
     * @param t
     * @param clazz
     * @param includeParents
     * @param overwriteValuesNotNull 是否覆盖非null值
     * @throws IllegalAccessException
     */
    private static void setRandomAttributesForBean(Object t, Class<?> clazz, boolean includeParents, boolean overwriteValuesNotNull) throws IllegalAccessException {
        Field[] fields = clazz.getDeclaredFields();
        for(Field f:fields){
            if((f.getModifiers() & Modifier.STATIC) == Modifier.STATIC || (f.getModifiers() & Modifier.FINAL) == Modifier.FINAL){
                continue;
            }
            f.setAccessible(true);
            Object currentValue = f.get(t);
            if(!overwriteValuesNotNull && currentValue != null){
                continue;
            }
            Class type = f.getType();
            if(type.equals(String.class)){
                f.set(t, RandomStringUtils.random(3,true,true));
            }else if(type.equals(Integer.class)){
                f.set(t, RandomUtils.nextInt());
            }else if(type.equals(Long.class)){
                f.set(t, RandomUtils.nextLong());
            }else if(type.equals(Date.class)){
                f.set(t, new Date());
            }else if(type.equals(Boolean.class)){
                f.set(t, RandomUtils.nextBoolean());
            }
        }
        if(includeParents) {
            Class parentClass = clazz.getSuperclass();
            if (parentClass != null) {
                setRandomAttributesForBean(t, parentClass, includeParents, overwriteValuesNotNull);
            }
        }
    }

    /**
     * 比较两个对象是否相同（通过反射比较field),如果不相同则抛出异常,用于方便单元测试
     * @param t1
     * @param t2
     * @param exceptFields 例外字段,这些字段不会被比较.
     * @param includeParents 是否比较父类中的属性
     * @param <T>
     * @return
     */
    public static <T> void assertEqualsReflect(T t1, T t2, boolean includeParents,String[] exceptFields){
        if(t1 == null && t2 == null){
            return;
        }
        if(t1 == null){
            throw new Error("left parameter is null");
        }
        if(t2 == null){
            throw new Error("right parameter is null");
        }
        Class c1 = t1.getClass();
        Class c2 = t2.getClass();
        if(!c1.equals(c2)){
            throw new Error("class not equal:["+c1.getName()+"],  ["+c2.getName()+"]");
        }

        Set<String> exceptFieldSet = new HashSet<String>();
        if(exceptFields!=null){
            exceptFieldSet.addAll(Arrays.asList(exceptFields));
        }

        assertEqualsReflect(t1,t2,t1.getClass(),includeParents,exceptFieldSet);
    }

    private static <T> void assertEqualsReflect(T t1, T t2, Class<?> clazz, boolean includeParents,Set<String> exceptFieldSet){
        Field[] fields = clazz.getDeclaredFields();
        for(Field f:fields){
            if(exceptFieldSet.contains(f.getName())){
                continue;
            }

            try {
                f.setAccessible(true);
                Object fv1 = f.get(t1);
                Object fv2 = f.get(t2);
                if(!ObjectUtils.equals(fv1, fv2)){
                    throw new Error("field:["+f.getName()+"] not equals,left is:"+fv1+", right is:"+fv2);
                }
            } catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }

        if(includeParents){
            clazz = clazz.getSuperclass();
            if(clazz!=null) {
                assertEqualsReflect(t1, t2, clazz, includeParents,exceptFieldSet);
            }
        }
    }
}
