package cn.com.duiba.wolf.dubbo;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;

/**
 * Created by xuezhaoming on 16/5/5. </br>
 * dubbo 调用统一返回结果对象
 */
public class DubboResult<T> implements Serializable {

    private static final long   serialVersionUID = -6978963188996203322L;

    private static final String SUCCESS          = "success";
    private static final String FAIL             = "fail";

    // 调用是否成功
    private boolean             isSuccess        = true;

    // 国际化的key，暂时不需要
    private String              i18nKey;

    // 调用结果信息
    private String              msg;

    // 调用结果
    private T                   result;

    public static final String  DEFAULT_MSG      = "defaultMSg";

    private DubboResult() {
    }

    private DubboResult(T result) {
        isSuccess = true;
        i18nKey = DEFAULT_MSG;
        msg = SUCCESS;
        this.result = result;
    }

    private DubboResult(String msg) {
        isSuccess = false;
        i18nKey = DEFAULT_MSG;
        this.msg = StringUtils.isEmpty(msg) ? FAIL : msg;
    }

    /**
     * 快速构建成功返回对象
     * 
     * @param result 返回结果
     * @return
     */
    public static <T> DubboResult<T> successResult(T result) {
        return new DubboResult<T>(result);
    }

    /**
     * 快速构建失败返回对象
     * 
     * @param msg 失败信息
     * @param <T>
     * @return
     */
    public static <T> DubboResult<T> failResult(String msg) {
        return new DubboResult<T>(msg);
    }

    public DubboResult(boolean isSuccess, String i18nKey, String msg, T result) {
        this.isSuccess = isSuccess;
        this.i18nKey = i18nKey;
        this.msg = msg;
        this.result = result;
    }

    public static DubboResult builder() {
        return new DubboResult();
    }

    public DubboResult isSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
        return this;
    }

    public DubboResult msg(String msg) {
        this.msg = msg;
        return this;
    }

    public DubboResult result(T result) {
        this.result = result;
        return this;
    }

    public DubboResult i18nKey(String i18nKey) {
        this.i18nKey = i18nKey;
        return this;
    }

    public DubboResult build() {
        return this;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getI18nKey() {
        return i18nKey;
    }

    public void setI18nKey(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    public T getResult() {
        return result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(boolean success) {
        isSuccess = success;
    }

    public static void main(String[] args) {

        DubboResult<String> dubboResult = mockDubboResult();

        if (dubboResult.isSuccess()) {
            // todo
        } else {
            // todo
        }
    }

    private static DubboResult<String> mockDubboResult() {
        return new DubboResult<String>();
    }
}
