/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.perf;

import cn.com.duiba.wolf.perf.PerfResult;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PerfCollector {
    private long startTime;
    private long endTime;
    private AtomicLong successCount = new AtomicLong();
    private AtomicLong failCount = new AtomicLong();
    private DescriptiveStatistics result = new DescriptiveStatistics();

    public void addValue(long value) {
        this.result.addValue((double)value);
    }

    public void addSuccess() {
        this.successCount.incrementAndGet();
    }

    public void addFail() {
        this.failCount.incrementAndGet();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public PerfResult compute() {
        PerfResult perfResult = new PerfResult();
        perfResult.setMin(this.result.getMin());
        perfResult.setMax(this.result.getMax());
        perfResult.setAvg(this.result.getSum() / (double)this.result.getN());
        perfResult.setSuccessCount(this.successCount.longValue());
        perfResult.setFailCount(this.failCount.longValue());
        perfResult.setMedian(this.median());
        perfResult.setPercent_90(this.result.getPercentile(90.0));
        perfResult.setPercent_95(this.result.getPercentile(95.0));
        perfResult.setSkewness(this.result.getSkewness());
        long costTime = (this.endTime - this.startTime) / 1000L;
        long count = this.successCount.longValue() + this.failCount.longValue();
        double tps = costTime == 0L ? count : count / costTime;
        perfResult.setTps(tps);
        return perfResult;
    }

    public double median() {
        double[] sortedValues = this.result.getSortedValues();
        int length = sortedValues.length;
        double j = 0.0;
        j = length % 2 == 0 ? (sortedValues[length / 2] + sortedValues[length / 2 + 1]) / 2.0 : sortedValues[length / 2];
        return j;
    }
}

