/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.dubbo;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcResult;
import com.alibaba.dubbo.rpc.service.GenericService;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class RuntimeExceptionFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RuntimeExceptionFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result = invoker.invoke(invocation);
        if (result.hasException() && GenericService.class != invoker.getInterface()) {
            try {
                Throwable exception = result.getException();
                if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                    return result;
                }
                if (exception instanceof RpcException) {
                    return result;
                }
                try {
                    Class<?>[] exceptionClassses;
                    Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                    for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                        if (!exception.getClass().equals(exceptionClass)) continue;
                        return result;
                    }
                    Class<?> clazz = method.getReturnType();
                    if (clazz.equals(Void.TYPE)) {
                        return result;
                    }
                    if (clazz.equals(DubboResult.class)) {
                        log.error(exception.getMessage(), exception);
                        return new RpcResult((Object)DubboResult.failResult((String)exception.getMessage()));
                    }
                    return result;
                }
                catch (NoSuchMethodException e) {
                    return result;
                }
            }
            catch (Throwable e) {
                return result;
            }
        }
        return result;
    }
}

