package cn.com.duiba.wolf.spring.datasource;

import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;

import javax.sql.DataSource;

/**
 * 配置读写分离时需要把事务管理器中的datasource和sqlsessionTemplate中的datasource配置为一样,故需要使用这个事务管理器,以防事务管理器从slave库获得connection.（这种异常情况出现的一个原因是:事务中获取到connection后,接下来事务内会重复使用同一个conn,不会再获取, 故ThreadLocal中的变量可能不会消失,然后下次复用同一个线程的时候就会走slave库了）
 * Created by wenqi.huang on 16/6/3.
 */
public class AutoRoutingDataSourceTransactionManager extends DataSourceTransactionManager {
    private static final long serialVersionUID = 2302242125555765541L;

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        DataSource ds = getDataSource();
        if(ds instanceof AutoRoutingDataSource){
            ((AutoRoutingDataSource) ds).setUseMasterDataSource(true);//开始事务得到连接前设置使用主库
        }

        super.doBegin(transaction, definition);
    }
}
