package cn.com.duiba.wolf.spring.selfaware;

import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * spring配置文件中需要配置这个后处理器,以使SelfAware接口生效.
 * <br/>
 * //另一个办法是启用exposeProxy,使用((AppBannerService)AopContext.currentProxy()).update();
 * Created by wenqi.huang on 16/6/2.
 */
public class SelfAwareBeanPostProcessor implements BeanPostProcessor,BeanFactoryAware{

    private BeanFactory beanFactory;

    @Override
    public Object postProcessBeforeInitialization(Object o, String beanName) throws BeansException {
        return o;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if(bean instanceof SelfAware){
            if(AopUtils.isAopProxy(bean)) {//如果当前对象是AOP代理对象，直接注入
                ((SelfAware) bean).setSelf(bean);
            }else{//如果当前对象不是AOP代理，则通过context.getBean(beanName)获取代理对象并注入(循环依赖时存在这个分支的情况)
                //此种方式不适合解决prototype Bean的代理对象注入
                ((SelfAware) bean).setSelf(beanFactory.getBean(beanName));
            }
        }
        return bean;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}
