/*
 * Copyright 1999-2011 Alibaba Group.
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *  
 *      http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package cn.com.duiba.wolf.dubbo.dispatcher;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.container.spring.SpringContainer;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Dispatcher;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * dubbo隔离线程池的配置,把不同RemoteService放到不同线程池中运行,以隔离
 * 
 * @author chao.liuc
 */
@Component
public class RoutingDispatcher implements Dispatcher, ApplicationContextAware {

    private static ApplicationContext springContext;
    public static final String NAME = "routing";

    public ChannelHandler dispatch(ChannelHandler handler, URL url) {
        Map<String,ExecutorService> map = springContext.getBeansOfType(ExecutorService.class);
        return new RoutingChannelHandler(handler, url, map);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        springContext = applicationContext;
    }
}
