/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.wolf.cache;

import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.NumberUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.command.KestrelCommandFactory;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.transcoders.SerializingTranscoder;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class XMemcacheClient
implements InitializingBean,
DisposableBean,
CacheClient {
    private static Logger logger = LoggerFactory.getLogger(XMemcacheClient.class);
    private final String CACHE_NAME = XMemcacheClient.class.getName();
    private static final int CACHE_NO_EXPIRY = 0;
    private static final int COUNTER_DEFAULT_INIT_VALUE = 0;
    private int connectionPoolSize;
    private int connectionTimeout = 60000;
    private int operationTimeout = 1000;
    private static final int DEFAULT_EXP = 172800;
    private MemcachedSessionLocator sessionLocator;
    private MemcachedClient memcachedClient;
    private String servers;
    private String authInfos;
    private String username;
    private String password;
    private boolean enableHeartBeat;
    private String protocol;

    @Override
    public boolean add(String key, int exp, Object value) throws Exception {
        return this.memcachedClient.add(key, exp, value);
    }

    @Override
    public <T> T get(String key) {
        T t = this.getInner(key);
        if (t != null && t instanceof NullCache) {
            return null;
        }
        return t;
    }

    private <T> T getInner(String key) {
        key = XMemcacheClient.getStringNoBlank(key);
        try {
            Object t = this.memcachedClient.get(key);
            return (T)t;
        }
        catch (IllegalArgumentException e) {
            logger.error(String.valueOf(e.getMessage()) + ",key is:" + key);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(String) error,key:" + key, (Throwable)e);
        }
        return null;
    }

    @Override
    public long getLong(String key) {
        Object obj;
        block7: {
            key = XMemcacheClient.getStringNoBlank(key);
            obj = this.memcachedClient.get(key);
            if (obj != null) break block7;
            return 0L;
        }
        try {
            if (obj instanceof String) {
                return NumberUtils.parseLong((String)obj, 0L);
            }
            if (obj instanceof Integer) {
                return ((Integer)obj).intValue();
            }
            if (obj instanceof Long) {
                return (Long)obj;
            }
        }
        catch (IllegalArgumentException e) {
            logger.error(String.valueOf(e.getMessage()) + ",key is:" + key);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(String) error,key:" + key, (Throwable)e);
        }
        return 0L;
    }

    public Map<String, Object> get(Collection<String> keys) {
        Map value = null;
        try {
            value = this.memcachedClient.get(keys);
        }
        catch (Exception e) {
            logger.error("memcachedClient get(Collection<String>) error", (Throwable)e);
        }
        return value;
    }

    @Override
    public boolean set(String key, Object value, int expSeconds) {
        return this.set(key, value, expSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean set(String key, Object value, int expiry, TimeUnit unit) {
        if (value == null) {
            return false;
        }
        key = XMemcacheClient.getStringNoBlank(key);
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            boolean success = this.memcachedClient.set(key, exp, value);
            return success;
        }
        catch (Exception e) {
            logger.error("memcachedClient set() error,key:" + key, (Throwable)e);
            return false;
        }
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, CacheLoader<T> cacheLoader) {
        return this.getWithCacheLoader(key, exp, timeUnit, false, cacheLoader);
    }

    @Override
    public <T> T getWithCacheLoader(String key, int exp, TimeUnit timeUnit, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        T value = this.getInner(key);
        if (value == null) {
            value = cacheLoader.load();
            if (isCacheNull) {
                this.setWithNull(key, value, exp, timeUnit);
            } else {
                this.set(key, value, exp, timeUnit);
            }
        }
        if (value instanceof NullCache) {
            value = null;
        }
        return value;
    }

    private void setWithNull(String key, Object value, int expiry, TimeUnit unit) {
        if (value == null) {
            value = NullCache.NULL;
        }
        this.set(key, value, expiry, unit);
    }

    @Override
    public long incr(String key, long delta) {
        return this.incr(key, delta, delta, 172800L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long incr(String key, long delta, long expiry, TimeUnit unit) {
        return this.incr(key, delta, delta, expiry, unit);
    }

    @Override
    public long incr(String key, long delta, long initValue, long expiry, TimeUnit unit) {
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            long count = this.memcachedClient.incr(key, delta, initValue, 5000L, exp);
            logger.debug("key:{},afterInce:{}", (Object)key, (Object)count);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long decr(String key, long delta) {
        return this.decr(key, delta, 0L, 172800L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long decr(String key, long delta, long expiry, TimeUnit unit) {
        return this.decr(key, delta, 0L, expiry, unit);
    }

    @Override
    public long decr(String key, long delta, long initValue, long expiry, TimeUnit unit) {
        int exp = this.getValidExpiryTime(expiry, unit);
        try {
            long count = this.memcachedClient.decr(key, delta, initValue, 5000L, exp);
            return count;
        }
        catch (Exception e) {
            logger.error("memcachedClient decr() error,key:" + key, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean cas(String key, Object expected, Object value, int expSeconds) {
        GetsResponse t;
        block6: {
            t = this.memcachedClient.gets(key);
            if (t != null) break block6;
            return false;
        }
        try {
            if (t.getValue().equals(expected)) {
                boolean success = this.memcachedClient.cas(key, expSeconds, value, t.getCas());
                return success;
            }
        }
        catch (TimeoutException e) {
            logger.error("memcachedClient cas() error,key:" + key, (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("memcachedClient cas() error,key:" + key, (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error("memcachedClient cas() error,key:" + key, (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean remove(String key) {
        key = XMemcacheClient.getStringNoBlank(key);
        try {
            boolean success = this.memcachedClient.delete(key);
            return success;
        }
        catch (Exception e) {
            logger.error("memcachedClient remove failed,key:" + key, (Throwable)e);
            return false;
        }
    }

    public void setSessionLocator(MemcachedSessionLocator sessionLocator) {
        this.sessionLocator = sessionLocator;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        if (this.memcachedClient != null) {
            this.memcachedClient.setConnectTimeout((long)connectionTimeout);
        }
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
        if (this.memcachedClient != null) {
            this.memcachedClient.setOpTimeout((long)operationTimeout);
        }
    }

    public String getServers() {
        return this.servers;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public String getAuthInfos() {
        return this.authInfos;
    }

    public void setAuthInfos(String authInfos) {
        this.authInfos = authInfos;
    }

    public static String getStringNoBlank(String str) {
        if (str != null && !"".equals(str)) {
            return str.replaceAll("\\s*|\t|\r|\n", "").replaceAll("\u3000", "").replaceAll("&nbsp;", "");
        }
        return str;
    }

    private void initClient() {
        if (this.memcachedClient != null) {
            logger.info(String.valueOf(this.CACHE_NAME) + " already initialized");
            return;
        }
        String[] servers = StringUtils.split((String)this.getServers(), (String)",");
        String[] authInfos = StringUtils.split((String)this.getAuthInfos(), (String)",");
        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
        HashMap<InetSocketAddress, AuthInfo> authInfoMap = new HashMap<InetSocketAddress, AuthInfo>();
        int i = 0;
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            InetSocketAddress address = AddrUtil.getOneAddress((String)server);
            addressList.add(address);
            if (authInfos != null && authInfos.length > 0) {
                String authInfo;
                String[] temp;
                if (authInfos != null && authInfos.length > i && (temp = (authInfo = authInfos[i]).split(":")).length >= 1) {
                    authInfoMap.put(address, AuthInfo.plain((String)temp[0], (String)temp[1]));
                    logger.info("auth " + server + " with username:" + temp[0] + ",password:" + temp[1]);
                }
            } else if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
                authInfoMap.put(address, AuthInfo.plain((String)this.username, (String)this.password));
            }
            ++i;
            ++n2;
        }
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(addressList);
        builder.setAuthInfoMap(authInfoMap);
        if (this.sessionLocator != null) {
            builder.setSessionLocator(this.sessionLocator);
        }
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(1024);
        builder.setTranscoder((Transcoder)transcoder);
        if (StringUtils.isBlank((String)this.protocol) || this.protocol.equals("BINARY")) {
            builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        } else if (this.protocol.equals("TEXT")) {
            builder.setCommandFactory((CommandFactory)new TextCommandFactory());
        } else if (this.protocol.equals("KESTREL")) {
            builder.setCommandFactory((CommandFactory)new KestrelCommandFactory());
        }
        builder.setKeyProvider(new KeyProvider(){

            public String process(String key) {
                if (key == null) {
                    return null;
                }
                return key.trim();
            }
        });
        builder.setHealSessionInterval(2000L);
        if (this.connectionPoolSize > 0) {
            builder.setConnectionPoolSize(this.connectionPoolSize);
        }
        try {
            this.memcachedClient = builder.build();
            this.memcachedClient.setConnectTimeout((long)this.connectionTimeout);
            this.memcachedClient.setOpTimeout((long)this.operationTimeout);
            this.memcachedClient.setEnableHeartBeat(this.enableHeartBeat);
            logger.info(addressList + " initialized{}");
        }
        catch (IOException e) {
            logger.error("Initialize " + this.getClass() + " error", (Throwable)e);
            throw new RuntimeException("Initialize " + this.getClass() + " error", e);
        }
        try {
            Field field = this.memcachedClient.getClass().getDeclaredField("shutdownHookThread");
            field.setAccessible(true);
            Thread shutdownHookThread = (Thread)field.get(this.memcachedClient);
            Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
        }
        catch (Exception e) {
            logger.error("warn: getField:shutdownHookThread error", (Throwable)e);
        }
    }

    public void addServer(String ... servers) throws IOException {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        StringBuilder hostList = new StringBuilder();
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            hostList.append(server).append(" ");
            ++n2;
        }
        hostList.deleteCharAt(hostList.length() - 1);
        this.memcachedClient.addServer(hostList.toString());
        logger.info("Memcached server(s) added: [" + hostList + "]");
    }

    public void addServers(String[] servers, int[] weights) throws IOException {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        if (weights != null && weights.length < servers.length) {
            throw new IllegalArgumentException("weights can't be less than servers");
        }
        int i = 0;
        while (i < servers.length) {
            InetSocketAddress address = AddrUtil.getOneAddress((String)servers[i]);
            this.memcachedClient.addServer(address, weights[i]);
            ++i;
        }
    }

    public void removeServer(String ... servers) {
        if (servers == null || servers.length == 0) {
            throw new IllegalArgumentException("servers can't be null");
        }
        StringBuilder hostList = new StringBuilder();
        String[] stringArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            hostList.append(server).append(" ");
            ++n2;
        }
        hostList.deleteCharAt(hostList.length() - 1);
        this.memcachedClient.removeServer(hostList.toString());
        logger.info("Memcached server(s) removed: [" + hostList + "]");
    }

    private int getValidExpiryTime(long expiry, TimeUnit unit) {
        int exp = (int)unit.toSeconds(expiry);
        return exp > 0 ? exp : 172800;
    }

    public void afterPropertiesSet() throws Exception {
        this.initClient();
    }

    public static void main(String[] args) throws Exception {
        XMemcacheClient client = new XMemcacheClient();
        client.setConnectionPoolSize(10);
        client.setServers("192.168.1.115:11211");
        client.afterPropertiesSet();
        client.set("helloworld", 1, 20);
        GetsResponse t = client.memcachedClient.gets("helloworld");
        if (t.getValue().equals(1)) {
            boolean success = client.memcachedClient.cas("helloworld", 2, (Object)2, t.getCas());
            System.out.println("--------" + client.get("helloworld"));
            Thread.sleep(3000L);
            System.out.println("--------" + client.get("helloworld"));
        }
        client.set("helloworld", 2, 20);
        client.cas("helloworld", 2, 10, 2);
        System.out.println("2--------" + client.get("helloworld"));
        Thread.sleep(1000L);
        System.out.println("2--------" + client.get("helloworld"));
    }

    @Override
    public void flushAll() {
        try {
            this.memcachedClient.flushAll();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setEnableHeartBeat(boolean enableHeartBeat) {
        this.enableHeartBeat = enableHeartBeat;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void destroy() throws Exception {
        this.memcachedClient.shutdown();
    }

    private static class NullCache
    implements Serializable {
        private static final long serialVersionUID = 8197695308667194378L;
        public static final NullCache NULL = new NullCache();

        private NullCache() {
        }
    }
}

